/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core;

import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.skds.core.SKDSCore;
import net.skds.core.api.IWorldExtended;
import net.skds.core.util.blockupdate.BlockUpdataer;
import net.skds.core.util.blockupdate.WWSGlobal;
import net.skds.core.util.configs.UniversalJsonReader;
import net.skds.core.util.data.capability.ChunkCapability;
import net.skds.core.util.data.capability.ChunkCapabilityData;

public class Events {
    private static long inTickTime = System.nanoTime();
    private static int lastTickTime = 0;

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save e) {
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load e) {
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load e) {
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch e) {
    }

    @SubscribeEvent
    public void attachCCap(AttachCapabilitiesEvent<Chunk> e) {
        e.addCapability(ChunkCapability.KEY, (ICapabilityProvider)new ChunkCapabilityData((Chunk)e.getObject()));
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World w = (World)e.getWorld();
        ((IWorldExtended)w).addWWS();
        BlockUpdataer.onWorldLoad(w);
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        WWSGlobal wwsg;
        boolean in = event.phase == TickEvent.Phase.START;
        World w = event.world;
        if (in) {
            wwsg = ((IWorldExtended)w).getWWS();
            wwsg.tickIn();
        }
        if (!in) {
            wwsg = ((IWorldExtended)w).getWWS();
            wwsg.tickOut();
            lastTickTime = (int)(System.nanoTime() - inTickTime);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tick(TickEvent.ServerTickEvent event) {
        boolean in;
        boolean bl = in = event.phase == TickEvent.Phase.START;
        if (in) {
            inTickTime = System.nanoTime();
        }
        BlockUpdataer.tick(in);
        if (!in) {
            lastTickTime = (int)(System.nanoTime() - inTickTime);
        }
    }

    @SubscribeEvent
    public void addReloadListenerEvent(AddReloadListenerEvent e) {
        UniversalJsonReader.DATA_PACK_RREGISTRIES = e.getDataPackRegistries();
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartedEvent e) {
        SKDSCore.SERVER = e.getServer();
    }

    public static int getLastTickTime() {
        return lastTickTime;
    }

    public static int getRemainingTickTimeNanos() {
        return 50000000 - (int)(System.nanoTime() - inTickTime);
    }

    public static int getRemainingTickTimeMicros() {
        return Events.getRemainingTickTimeNanos() / 1000;
    }

    public static int getRemainingTickTimeMilis() {
        return Events.getRemainingTickTimeNanos() / 1000000;
    }
}

