/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ModelUpdatePacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;

    public ModelUpdatePacket() {
        super(8, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        World world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        BlockState state = world.func_180495_p(this.pos);
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile != null) {
            tile.requestModelDataUpdate();
        }
        world.func_184138_a(this.pos, state, state, 3);
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
    }

    public static void sendToClient(World world, BlockPos pos) {
        if (world == null || Utils.isClientWorld(world)) {
            return;
        }
        ModelUpdatePacket packet = new ModelUpdatePacket();
        packet.pos = pos;
        packet.sendToAllAround(packet.pos, 192.0, (RegistryKey<World>)world.func_234923_W_());
    }
}

