/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory.container;

import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.util.filter.AbstractItemFilter;
import cofh.lib.inventory.container.ContainerCoFH;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.container.slot.SlotLocked;
import cofh.lib.inventory.wrapper.InvWrapperGeneric;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.filter.IFilterableItem;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class HeldItemFilterContainer
extends ContainerCoFH
implements IFilterOptions {
    protected final IFilterableItem filterable;
    protected AbstractItemFilter filter;
    protected InvWrapperGeneric filterInventory;
    protected ItemStack filterStack;
    public SlotLocked lockedSlot;

    public HeldItemFilterContainer(int windowId, PlayerInventory inventory, PlayerEntity player) {
        super(CoreReferences.HELD_ITEM_FILTER_CONTAINER, windowId, inventory, player);
        this.allowSwap = false;
        this.filterStack = FilterHelper.hasFilter(player.func_184614_ca()) ? player.func_184614_ca() : player.func_184592_cb();
        this.filterable = (IFilterableItem)this.filterStack.func_77973_b();
        this.filter = (AbstractItemFilter)this.filterable.getFilter(this.filterStack);
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperGeneric(this, this.filter.getItems(), slots);
        int rows = MathHelper.clamp(slots / 3, 1, 3);
        int rowSize = slots / rows;
        int xOffset = 62 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        for (int i = 0; i < this.filter.size(); ++i) {
            this.func_75146_a(new SlotFalseCopy(this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    @Override
    protected void bindPlayerInventory(PlayerInventory inventory) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.field_70461_c) {
                this.lockedSlot = new SlotLocked((IInventory)inventory, i, xOffset + i * 18, yOffset + 58);
                this.func_75146_a(this.lockedSlot);
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    @Override
    protected int getMergeableSlotCount() {
        return this.filterInventory.func_70302_i_();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.filter.setItems(this.filterInventory.getStacks());
        this.filter.write(this.filterStack.func_196082_o());
        this.filterable.onFilterChanged(this.filterStack);
        super.func_75134_a(playerIn);
    }

    @Override
    public PacketBuffer getContainerPacket(PacketBuffer buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleContainerPacket(PacketBuffer buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    @Override
    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerPacket.sendToServer(this);
        return ret;
    }

    @Override
    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerPacket.sendToServer(this);
        return ret;
    }
}

