/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.network.packet.client.EffectAddedPacket;
import cofh.core.network.packet.client.EffectRemovedPacket;
import cofh.lib.potion.CustomParticleEffect;
import cofh.lib.util.references.CoreReferences;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class EffectEvents {
    private static final int CLARITY_MOD = 20;

    private EffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleChorusFruitTeleportEvent(EntityTeleportEvent.ChorusFruit event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a(CoreReferences.ENDERFERENCE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderEntityTeleportEvent(EntityTeleportEvent.EnderEntity event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a(CoreReferences.ENDERFERENCE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEnderPearlTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        if (event.isCanceled()) {
            return;
        }
        ServerPlayerEntity entity = event.getPlayer();
        if (entity.func_70644_a(CoreReferences.ENDERFERENCE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.func_70644_a(CoreReferences.LIGHTNING_RESISTANCE)) {
                event.setCanceled(true);
            } else {
                living.func_195064_c(new EffectInstance(CoreReferences.SHOCKED, 100, 0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (source.func_151517_h()) {
            return;
        }
        if (source.func_94541_c() && entity.func_70644_a(CoreReferences.EXPLOSION_RESISTANCE)) {
            event.setCanceled(true);
        } else if (source.func_82725_o() && entity.func_70644_a(CoreReferences.MAGIC_RESISTANCE)) {
            event.setCanceled(true);
        } else if (source == DamageSource.field_180137_b && entity.func_70644_a(CoreReferences.LIGHTNING_RESISTANCE)) {
            event.setCanceled(true);
        } else if (source.func_76347_k()) {
            entity.func_195063_d(CoreReferences.CHILLED);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionColorEvent(PotionColorCalculationEvent event) {
        Collection effects = event.getEffects();
        if (effects.isEmpty()) {
            return;
        }
        Predicate<EffectInstance> hasCustomParticle = effect -> effect.func_188419_a() instanceof CustomParticleEffect;
        if (effects.stream().anyMatch(hasCustomParticle)) {
            List nonCustom = effects.stream().filter(hasCustomParticle.negate()).collect(Collectors.toList());
            if (nonCustom.isEmpty()) {
                event.shouldHideParticles(true);
            } else {
                event.setColor(PotionUtils.func_185181_a(nonCustom));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionAddEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getPotionEffect().func_188419_a() instanceof CustomParticleEffect) {
            EffectAddedPacket.sendToClient(event.getEntityLiving(), event.getPotionEffect());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        EffectInstance effect = event.getPotionEffect();
        if (effect != null && effect.func_188419_a() instanceof CustomParticleEffect) {
            EffectRemovedPacket.sendToClient(event.getEntityLiving(), event.getPotionEffect());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleXpChangeEvent(PlayerXpEvent.XpChange event) {
        if (event.isCanceled() || event.getAmount() <= 0) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        EffectInstance clarityEffect = player.func_70660_b(CoreReferences.CLARITY);
        if (clarityEffect == null) {
            return;
        }
        event.setAmount(EffectEvents.getXPValue(event.getAmount(), clarityEffect.func_76458_c()));
    }

    private static int getXPValue(int baseExp, int amplifier) {
        return baseExp * (100 + 20 * (1 + amplifier)) / 100;
    }
}

