/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CombinerRecipeSerializer<RECIPE extends CombinerRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public CombinerRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray mainInput = JSONUtils.func_151202_d((JsonObject)json, (String)"mainInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"mainInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"mainInput");
        ItemStackIngredient mainIngredient = ItemStackIngredient.deserialize((JsonElement)mainInput);
        JsonArray extraInput = JSONUtils.func_151202_d((JsonObject)json, (String)"extraInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"extraInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"extraInput");
        ItemStackIngredient extraIngredient = ItemStackIngredient.deserialize((JsonElement)extraInput);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        if (output.func_190926_b()) {
            throw new JsonSyntaxException("Combiner recipe output must not be empty.");
        }
        return this.factory.create(recipeId, mainIngredient, extraIngredient, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient mainInput = ItemStackIngredient.read(buffer);
            ItemStackIngredient extraInput = ItemStackIngredient.read(buffer);
            ItemStack output = buffer.func_150791_c();
            return this.factory.create(recipeId, mainInput, extraInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading combiner recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((CombinerRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing combiner recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends CombinerRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStackIngredient var3, ItemStack var4);
    }
}

