/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorInfo;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AcceptorCache<ACCEPTOR>
extends AbstractAcceptorCache<ACCEPTOR, AcceptorInfo<ACCEPTOR>> {
    public AcceptorCache(Transmitter<ACCEPTOR, ?, ?> transmitter, TileEntityTransmitter transmitterTile) {
        super(transmitter, transmitterTile);
    }

    protected void updateCachedAcceptorAndListen(Direction side, TileEntity acceptorTile, LazyOptional<ACCEPTOR> acceptor) {
        this.updateCachedAcceptorAndListen(side, acceptorTile, acceptor, acceptor, true);
    }

    protected void updateCachedAcceptorAndListen(Direction side, TileEntity acceptorTile, LazyOptional<ACCEPTOR> acceptor, LazyOptional<?> sourceAcceptor, boolean sourceIsSame) {
        boolean dirtyAcceptor = false;
        if (this.cachedAcceptors.containsKey(side)) {
            AcceptorInfo acceptorInfo = (AcceptorInfo)this.cachedAcceptors.get(side);
            if (acceptorTile != acceptorInfo.getTile()) {
                this.cachedAcceptors.put(side, new AcceptorInfo(acceptorTile, sourceAcceptor, acceptor));
                dirtyAcceptor = true;
            } else if (sourceAcceptor != acceptorInfo.sourceAcceptor) {
                acceptorInfo.updateAcceptor(sourceAcceptor, acceptor);
                dirtyAcceptor = true;
            }
        } else {
            this.cachedAcceptors.put(side, new AcceptorInfo(acceptorTile, sourceAcceptor, acceptor));
            dirtyAcceptor = true;
        }
        if (dirtyAcceptor) {
            this.transmitter.markDirtyAcceptor(side);
            NonNullConsumer refreshListener = this.getRefreshListener(side);
            if (sourceIsSame) {
                acceptor.addListener(refreshListener);
            } else {
                CapabilityUtils.addListener(sourceAcceptor, refreshListener);
            }
        }
    }

    @Override
    public LazyOptional<ACCEPTOR> getConnectedAcceptor(Direction side) {
        AcceptorInfo acceptorInfo;
        if (this.cachedAcceptors.containsKey(side) && !(acceptorInfo = (AcceptorInfo)this.cachedAcceptors.get(side)).getTile().func_145837_r()) {
            return acceptorInfo.acceptor;
        }
        return LazyOptional.empty();
    }

    @Nullable
    public TileEntity getConnectedAcceptorTile(Direction side) {
        TileEntity tile;
        if (this.cachedAcceptors.containsKey(side) && !(tile = ((AcceptorInfo)this.cachedAcceptors.get(side)).getTile()).func_145837_r()) {
            return tile;
        }
        return null;
    }

    public boolean isAcceptorAndListen(@Nullable TileEntity tile, Direction side, Capability<ACCEPTOR> capability) {
        LazyOptional<ACCEPTOR> acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, capability, side.func_176734_d());
        if (acceptor.isPresent()) {
            this.updateCachedAcceptorAndListen(side, tile, acceptor);
            return true;
        }
        return false;
    }

    public static class AcceptorInfo<ACCEPTOR>
    extends AbstractAcceptorInfo {
        private LazyOptional<?> sourceAcceptor;
        private LazyOptional<ACCEPTOR> acceptor;

        private AcceptorInfo(TileEntity tile, LazyOptional<?> sourceAcceptor, LazyOptional<ACCEPTOR> acceptor) {
            super(tile);
            this.acceptor = acceptor;
            this.sourceAcceptor = sourceAcceptor;
        }

        private void updateAcceptor(LazyOptional<?> sourceAcceptor, LazyOptional<ACCEPTOR> acceptor) {
            this.sourceAcceptor = sourceAcceptor;
            this.acceptor = acceptor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AcceptorInfo) {
                AcceptorInfo other = (AcceptorInfo)o;
                return this.getTile().equals(other.getTile()) && this.sourceAcceptor.equals(other.sourceAcceptor) && this.acceptor.equals(other.acceptor);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getTile(), this.sourceAcceptor, this.acceptor);
        }
    }
}

