/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.type;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.inventory.container.type.BaseMekanismContainerType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.IContainerFactory;

public class MekanismItemContainerType<ITEM extends Item, CONTAINER extends Container>
extends BaseMekanismContainerType<ITEM, CONTAINER, IMekanismItemContainerFactory<ITEM, CONTAINER>> {
    public static <ITEM extends Item, CONTAINER extends Container> MekanismItemContainerType<ITEM, CONTAINER> item(Class<ITEM> type, IMekanismItemContainerFactory<ITEM, CONTAINER> constructor) {
        return new MekanismItemContainerType<ITEM, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, (Hand)buf.func_179257_a(Hand.class), MekanismItemContainerType.getStackFromBuffer(buf, type)));
    }

    public static <ITEM extends Item, CONTAINER extends Container> MekanismItemContainerType<ITEM, CONTAINER> item(Class<ITEM> type, IMekanismSidedItemContainerFactory<ITEM, CONTAINER> constructor) {
        return new MekanismItemContainerType<ITEM, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, (Hand)buf.func_179257_a(Hand.class), MekanismItemContainerType.getStackFromBuffer(buf, type), true));
    }

    protected MekanismItemContainerType(Class<ITEM> type, IMekanismItemContainerFactory<ITEM, CONTAINER> mekanismConstructor, IContainerFactory<CONTAINER> constructor) {
        super(type, mekanismConstructor, constructor);
    }

    @Nullable
    public CONTAINER create(int id, PlayerInventory inv, Hand hand, ItemStack stack) {
        if (!stack.func_190926_b() && this.type.isInstance(stack.func_77973_b())) {
            return ((IMekanismItemContainerFactory)this.mekanismConstructor).create(id, inv, hand, stack);
        }
        return null;
    }

    @Nullable
    public IContainerProvider create(Hand hand, ItemStack stack) {
        if (!stack.func_190926_b() && this.type.isInstance(stack.func_77973_b())) {
            return (id, inv, player) -> ((IMekanismItemContainerFactory)this.mekanismConstructor).create(id, inv, hand, stack);
        }
        return null;
    }

    @Nonnull
    private static <ITEM extends Item> ItemStack getStackFromBuffer(PacketBuffer buf, Class<ITEM> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer");
        }
        ItemStack stack = buf.func_150791_c();
        if (type.isInstance(stack.func_77973_b())) {
            return stack;
        }
        throw new IllegalStateException("Client received invalid stack (" + stack.func_77973_b().getRegistryName() + ") for item container.");
    }

    @FunctionalInterface
    public static interface IMekanismSidedItemContainerFactory<ITEM extends Item, CONTAINER extends Container>
    extends IMekanismItemContainerFactory<ITEM, CONTAINER> {
        public CONTAINER create(int var1, PlayerInventory var2, Hand var3, ItemStack var4, boolean var5);

        @Override
        default public CONTAINER create(int id, PlayerInventory inv, Hand hand, ItemStack stack) {
            return this.create(id, inv, hand, stack, false);
        }
    }

    @FunctionalInterface
    public static interface IMekanismItemContainerFactory<ITEM extends Item, CONTAINER extends Container> {
        public CONTAINER create(int var1, PlayerInventory var2, Hand var3, ItemStack var4);
    }
}

