/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.MekanismRecipeManager")
public abstract class MekanismRecipeManager<RECIPE extends MekanismRecipe>
implements IRecipeManager {
    private final MekanismRecipeType<RECIPE, ?> recipeType;

    protected MekanismRecipeManager(MekanismRecipeType<RECIPE, ?> recipeType) {
        this.recipeType = recipeType;
    }

    protected abstract ActionAddMekanismRecipe getAction(RECIPE var1);

    protected void addRecipe(RECIPE recipe) {
        CraftTweakerAPI.apply((IAction)this.getAction(recipe));
    }

    public IRecipeType<RECIPE> getRecipeType() {
        return this.recipeType;
    }

    public ResourceLocation getBracketResourceLocation() {
        return this.recipeType.getRegistryName();
    }

    @Deprecated
    public List<WrapperRecipe> getRecipesByOutput(IIngredient output) {
        throw new UnsupportedOperationException("Mekanism's recipe managers don't support reverse lookup by output, please lookup by recipe name.");
    }

    @Deprecated
    public void removeRecipe(IIngredient output) {
        throw new UnsupportedOperationException("Mekanism's recipe managers don't support removal by output, please remove by recipe name.");
    }

    protected ResourceLocation getAndValidateName(String path) {
        return CrTUtils.rl(this.validateRecipeName(path));
    }

    protected ItemStack getAndValidateNotEmpty(IItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Output stack cannot be empty.");
        }
        return stack.getImmutableInternal();
    }

    protected FluidStack getAndValidateNotEmpty(IFluidStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Output stack cannot be empty.");
        }
        return stack.getImmutableInternal();
    }

    protected <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK getAndValidateNotEmpty(ICrTChemicalStack<CHEMICAL, STACK, ?> stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Output stack cannot be empty.");
        }
        return stack.getImmutableInternal();
    }

    protected static abstract class ActionAddMekanismRecipe
    extends ActionAddRecipe {
        final /* synthetic */ MekanismRecipeManager this$0;

        protected ActionAddMekanismRecipe(RECIPE recipe) {
            this.this$0 = this$0;
            super((IRecipeManager)this$0, recipe, "");
        }

        protected RECIPE getRecipe() {
            return (MekanismRecipe)this.recipe;
        }

        protected abstract String describeOutputs();
    }
}

