/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.common.integration.crafttweaker.bracket.IBracketSupport;
import mekanism.common.integration.crafttweaker.ingredient.CrTGasStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTInfusionStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTPigmentStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTSlurryStackIngredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.chemical.ChemicalStack")
public interface ICrTChemicalStack<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>>
extends CommandStringDisplayable,
IBracketSupport {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return ((ChemicalStack)this.getInternal()).getTypeRegistryName();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return ((ChemicalStack)this.getInternal()).isEmpty();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="amount")
    default public long getAmount() {
        return ((ChemicalStack)this.getInternal()).getAmount();
    }

    @ZenCodeType.Method
    public CRT_STACK setAmount(long var1);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public CRT_STACK multiply(long amount) {
        return this.setAmount(this.getAmount() * amount);
    }

    @ZenCodeType.Method
    default public CRT_STACK grow(long amount) {
        return this.setAmount(this.getAmount() + amount);
    }

    @ZenCodeType.Method
    default public CRT_STACK shrink(long amount) {
        return this.setAmount(this.getAmount() - amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean containsOther(CRT_STACK stack) {
        return this.isTypeEqual(stack) && ((ChemicalStack)this.getInternal()).getAmount() >= ((ChemicalStack)stack.getInternal()).getAmount();
    }

    @ZenCodeType.Method
    public CRT_STACK asMutable();

    @ZenCodeType.Method
    public CRT_STACK asImmutable();

    @ZenCodeType.Method
    public CRT_STACK copy();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="type")
    @ZenCodeType.Caster(implicit=true)
    default public CHEMICAL getType() {
        return ((ChemicalStack)this.getInternal()).getType();
    }

    public STACK getInternal();

    default public STACK getImmutableInternal() {
        return this.copy().getInternal();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean isTypeEqual(CRT_STACK stack) {
        return ((ChemicalStack)this.getInternal()).isTypeEqual(stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    default public boolean isEqual(CRT_STACK other) {
        return this.equals(other);
    }

    @ZenCodeType.Caster(implicit=true)
    public IChemicalStackIngredient<?, ?> asChemicalStackIngredient();

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.SlurryStack")
    public static interface ICrTSlurryStack
    extends ICrTChemicalStack<Slurry, SlurryStack, ICrTSlurryStack>,
    IBracketSupport.ISlurryBracketSupport {
        @Override
        default public IChemicalStackIngredient<Slurry, SlurryStack> asChemicalStackIngredient() {
            return this.asSlurryStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public SlurryStackIngredient asSlurryStackIngredient() {
            return CrTSlurryStackIngredient.from(this);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.PigmentStack")
    public static interface ICrTPigmentStack
    extends ICrTChemicalStack<Pigment, PigmentStack, ICrTPigmentStack>,
    IBracketSupport.IPigmentBracketSupport {
        @Override
        default public IChemicalStackIngredient<Pigment, PigmentStack> asChemicalStackIngredient() {
            return this.asPigmentStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public PigmentStackIngredient asPigmentStackIngredient() {
            return CrTPigmentStackIngredient.from(this);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.InfusionStack")
    public static interface ICrTInfusionStack
    extends ICrTChemicalStack<InfuseType, InfusionStack, ICrTInfusionStack>,
    IBracketSupport.IInfuseTypeBracketSupport {
        @Override
        default public IChemicalStackIngredient<InfuseType, InfusionStack> asChemicalStackIngredient() {
            return this.asInfusionStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public InfusionStackIngredient asInfusionStackIngredient() {
            return CrTInfusionStackIngredient.from(this);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.GasStack")
    public static interface ICrTGasStack
    extends ICrTChemicalStack<Gas, GasStack, ICrTGasStack>,
    IBracketSupport.IGasBracketSupport {
        @Override
        default public IChemicalStackIngredient<Gas, GasStack> asChemicalStackIngredient() {
            return this.asGasStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public GasStackIngredient asGasStackIngredient() {
            return CrTGasStackIngredient.from(this);
        }
    }
}

