/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;

@ParametersAreNonnullByDefault
public class ModuleElectrolyticBreathingUnit
implements ICustomModule<ModuleElectrolyticBreathingUnit> {
    private IModuleConfigItem<Boolean> fillHeld;

    @Override
    public void init(IModule<ModuleElectrolyticBreathingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.fillHeld = configItemCreator.createConfigItem("fill_held", MekanismLang.MODULE_BREATHING_HELD, new ModuleBooleanData());
    }

    @Override
    public void tickServer(IModule<ModuleElectrolyticBreathingUnit> module, PlayerEntity player) {
        int productionRate = 0;
        float eyeHeight = player.func_70047_e();
        Map<Fluid, MekanismUtils.FluidInDetails> fluidsIn = MekanismUtils.getFluidsIn(player, bb -> {
            double centerX = (bb.field_72340_a + bb.field_72336_d) / 2.0;
            double centerZ = (bb.field_72339_c + bb.field_72334_f) / 2.0;
            return new AxisAlignedBB(centerX, Math.min(bb.field_72338_b + (double)eyeHeight - 0.27, bb.field_72337_e), centerZ, centerX, Math.min(bb.field_72338_b + (double)eyeHeight - 0.14, bb.field_72337_e), centerZ);
        });
        if (fluidsIn.entrySet().stream().anyMatch(entry -> ((Fluid)entry.getKey()).func_207185_a((ITag)FluidTags.field_206959_a) && ((MekanismUtils.FluidInDetails)entry.getValue()).getMaxHeight() >= 0.11)) {
            productionRate = this.getMaxRate(module);
        } else if (player.func_209511_p()) {
            productionRate = this.getMaxRate(module) / 2;
        }
        if (productionRate > 0) {
            ItemStack handStack;
            Optional handCapability;
            Optional chestCapability;
            FloatingLong usage = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L);
            int maxRate = Math.min(productionRate, module.getContainerEnergy().divideToInt(usage));
            long hydrogenUsed = 0L;
            GasStack hydrogenStack = MekanismGases.HYDROGEN.getStack((long)maxRate * 2L);
            ItemStack chestStack = player.func_184582_a(EquipmentSlotType.CHEST);
            if (this.checkChestPlate(chestStack) && (chestCapability = chestStack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve()).isPresent()) {
                hydrogenUsed = (long)maxRate * 2L - ((IGasHandler)chestCapability.get()).insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
                hydrogenStack.shrink(hydrogenUsed);
            }
            if (this.fillHeld.get().booleanValue() && (handCapability = (handStack = player.func_184582_a(EquipmentSlotType.MAINHAND)).getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve()).isPresent()) {
                hydrogenUsed = (long)maxRate * 2L - ((IGasHandler)handCapability.get()).insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
            }
            int oxygenUsed = Math.min(maxRate, player.func_205010_bg() - player.func_70086_ai());
            long used = Math.max((int)Math.ceil((double)hydrogenUsed / 2.0), oxygenUsed);
            module.useEnergy((LivingEntity)player, usage.multiply(used));
            player.func_70050_g(player.func_70086_ai() + oxygenUsed);
        }
    }

    private boolean checkChestPlate(ItemStack chestPlate) {
        if (chestPlate.func_77973_b() == MekanismItems.MEKASUIT_BODYARMOR.get()) {
            return MekanismAPI.getModuleHelper().load(chestPlate, MekanismModules.JETPACK_UNIT) != null;
        }
        return true;
    }

    private int getMaxRate(IModule<ModuleElectrolyticBreathingUnit> module) {
        return (int)Math.pow(2.0, module.getInstalledCount());
    }
}

