/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.heat;

import java.util.Arrays;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.heat.HeatAPI;
import mekanism.common.util.EnumUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CachedAmbientTemperature
implements DoubleSupplier {
    private final double[] ambientTemperature = new double[EnumUtils.DIRECTIONS.length + 1];
    private final Supplier<World> worldSupplier;
    private final Supplier<BlockPos> positionSupplier;

    public CachedAmbientTemperature(Supplier<World> worldSupplier, Supplier<BlockPos> positionSupplier) {
        this.worldSupplier = worldSupplier;
        this.positionSupplier = positionSupplier;
        Arrays.fill(this.ambientTemperature, -1.0);
    }

    @Override
    public double getAsDouble() {
        return this.getTemperature(null);
    }

    public double getTemperature(@Nullable Direction side) {
        int index = side == null ? EnumUtils.DIRECTIONS.length : side.ordinal();
        double biomeAmbientTemp = this.ambientTemperature[index];
        if (biomeAmbientTemp == -1.0) {
            World world = this.worldSupplier.get();
            if (world == null) {
                return 300.0;
            }
            BlockPos pos = this.positionSupplier.get();
            if (side != null) {
                pos = pos.func_177972_a(side);
            }
            this.ambientTemperature[index] = HeatAPI.getAmbientTemp((IWorldReader)world, pos);
            return this.ambientTemperature[index];
        }
        return biomeAmbientTemp;
    }
}

