/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tile.qio.TileEntityQIODriveArray;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.data.IModelData;

public class DriveArrayBakedModel
extends ExtensionBakedModel<byte[]> {
    private static final float[][] DRIVE_PLACEMENTS = new float[][]{{0.0f, 0.375f}, {-0.125f, 0.375f}, {-0.25f, 0.375f}, {-0.4375f, 0.375f}, {-0.5625f, 0.375f}, {-0.6875f, 0.375f}, {0.0f, 0.0f}, {-0.125f, 0.0f}, {-0.25f, 0.0f}, {-0.4375f, 0.0f}, {-0.5625f, 0.0f}, {-0.6875f, 0.0f}};

    public DriveArrayBakedModel(IBakedModel original) {
        super(original);
    }

    @Override
    public List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<byte[]> key) {
        byte[] driveStatus = key.getData();
        List<BakedQuad> ret = key.getQuads();
        Direction side = key.getSide();
        BlockState blockState = key.getBlockState();
        if (blockState != null && side == Attribute.getFacing(blockState)) {
            ret = new ArrayList<BakedQuad>(ret);
            ArrayList<BakedQuad> driveQuads = new ArrayList<BakedQuad>();
            for (int i = 0; i < driveStatus.length; ++i) {
                TileEntityQIODriveArray.DriveStatus status = TileEntityQIODriveArray.DriveStatus.STATUSES[driveStatus[i]];
                if (status == TileEntityQIODriveArray.DriveStatus.NONE) continue;
                driveQuads.addAll(this.getDriveQuads(i, status, key));
            }
            ret.addAll(QuadUtils.transformBakedQuads(driveQuads, QuadTransformation.rotate(side)));
        }
        return ret;
    }

    private List<BakedQuad> getDriveQuads(int index, TileEntityQIODriveArray.DriveStatus status, ExtensionBakedModel.QuadsKey<byte[]> key) {
        List ret = MekanismModelCache.INSTANCE.QIO_DRIVES[status.ordinal()].getBakedModel().func_200117_a(key.getBlockState(), null, key.getRandom());
        float[] translation = DRIVE_PLACEMENTS[index];
        return QuadUtils.transformBakedQuads(ret, QuadTransformation.translate(new Vector3d((double)translation[0], (double)translation[1], 0.0)));
    }

    @Override
    @Nullable
    public ExtensionBakedModel.QuadsKey<byte[]> createKey(ExtensionBakedModel.QuadsKey<byte[]> key, IModelData data) {
        byte[] driveStatus = (byte[])data.getData(TileEntityQIODriveArray.DRIVE_STATUS_PROPERTY);
        if (driveStatus == null) {
            return null;
        }
        return key.data(driveStatus, Arrays.hashCode(driveStatus), Arrays::equals);
    }

    protected DriveArrayBakedModel wrapModel(IBakedModel model) {
        return new DriveArrayBakedModel(model);
    }
}

