/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.Color;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.text.EnergyDisplay;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SPSRecipeCategory
extends BaseRecipeCategory<SPSJEIRecipe> {
    private final GuiGauge<?> input;
    private final GuiGauge<?> output;

    public SPSRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.SPS_CASING.getRegistryName(), (ITextComponent)MekanismLang.SPS.translate(new Object[0]), SPSRecipeCategory.createIcon(helper, MekanismItems.ANTIMATTER_PELLET), 3, 12, 168, 74);
        this.addElement(new GuiInnerScreen((IGuiWrapper)this, 26, 13, 122, 60, () -> {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add(MekanismLang.STATUS.translate(MekanismLang.ACTIVE));
            list.add(MekanismLang.SPS_ENERGY_INPUT.translate(EnergyDisplay.of(((FloatingLong)MekanismConfig.general.spsEnergyPerInput.get()).multiply(MekanismConfig.general.spsInputPerAntimatter.get()))));
            list.add(MekanismLang.PROCESS_RATE_MB.translate(1.0));
            return list;
        }));
        this.input = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 6, 13));
        this.output = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 150, 13));
        this.addElement(new GuiDynamicHorizontalRateBar((IGuiWrapper)this, this.getBarProgressTimer(), 6, 75, 160, Color.ColorFunction.scale(Color.rgbi(60, 45, 74), Color.rgbi(100, 30, 170))));
    }

    @Nonnull
    public Class<? extends SPSJEIRecipe> getRecipeClass() {
        return SPSJEIRecipe.class;
    }

    public void setIngredients(SPSJEIRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(recipe.input.getRepresentations()));
        ingredients.setOutput(MekanismJEI.TYPE_GAS, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SPSJEIRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initChemical(gasStacks, 0, true, this.input, recipe.input.getRepresentations());
        this.initChemical(gasStacks, 1, false, this.output, Collections.singletonList(recipe.output));
    }

    public static List<SPSJEIRecipe> getSPSRecipes() {
        return Collections.singletonList(new SPSJEIRecipe(GasStackIngredient.from(MekanismGases.POLONIUM, (long)MekanismConfig.general.spsInputPerAntimatter.get()), MekanismGases.ANTIMATTER.getStack(1L)));
    }

    public static class SPSJEIRecipe {
        private final GasStackIngredient input;
        private final GasStack output;

        public SPSJEIRecipe(GasStackIngredient input, GasStack output) {
            this.input = input;
            this.output = output;
        }
    }
}

