/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.machine.GuiChemicalCrystallizer;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;

public class ChemicalCrystallizerRecipeCategory
extends BaseRecipeCategory<ChemicalCrystallizerRecipe> {
    private final Map<ChemicalCrystallizerRecipe, IngredientTarget> ingredients = new WeakHashMap<ChemicalCrystallizerRecipe, IngredientTarget>();
    private final OreInfo oreInfo = new OreInfo();
    private final GuiGauge<?> gauge = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 7, 4));
    private final GuiSlot output;
    private final GuiSlot slurryOreSlot;

    public ChemicalCrystallizerRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.CHEMICAL_CRYSTALLIZER, 5, 3, 147, 79);
        this.addSlot(SlotType.INPUT, 8, 65).with(SlotOverlay.PLUS);
        this.output = this.addSlot(SlotType.OUTPUT, 129, 57);
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 53, 61);
        this.addElement(new GuiInnerScreen((IGuiWrapper)this, 31, 13, 115, 42, () -> GuiChemicalCrystallizer.getScreenRenderStrings(this.oreInfo)));
        this.slurryOreSlot = this.addElement(new GuiSlot(SlotType.ORE, this, 128, 13).setRenderAboveSlots());
    }

    public Class<? extends ChemicalCrystallizerRecipe> getRecipeClass() {
        return ChemicalCrystallizerRecipe.class;
    }

    @Override
    public void draw(ChemicalCrystallizerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.oreInfo.currentRecipe = recipe;
        IngredientTarget target = this.ingredients.get(recipe);
        if (target != null) {
            this.oreInfo.ingredient = (IGuiIngredient)target.ingredientGroup.getGuiIngredients().get(0);
            this.oreInfo.itemIngredient = target.itemIngredientGroup == null ? null : (IGuiIngredient)target.itemIngredientGroup.getGuiIngredients().get(1);
        }
        super.draw(recipe, matrixStack, mouseX, mouseY);
        this.oreInfo.currentRecipe = null;
        this.oreInfo.ingredient = null;
        this.oreInfo.itemIngredient = null;
    }

    public void setIngredients(ChemicalCrystallizerRecipe recipe, IIngredients ingredients) {
        IChemicalStackIngredient<?, ?> input = recipe.getInput();
        if (input instanceof GasStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(((GasStackIngredient)input).getRepresentations()));
        } else if (input instanceof InfusionStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_INFUSION, Collections.singletonList(((InfusionStackIngredient)input).getRepresentations()));
        } else if (input instanceof PigmentStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_PIGMENT, Collections.singletonList(((PigmentStackIngredient)input).getRepresentations()));
        } else if (input instanceof SlurryStackIngredient) {
            ingredients.setInputLists(MekanismJEI.TYPE_SLURRY, Collections.singletonList(((SlurryStackIngredient)input).getRepresentations()));
        }
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChemicalCrystallizerRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 0, false, this.output, recipe.getOutputDefinition());
        IChemicalStackIngredient<?, ?> input = recipe.getInput();
        if (input instanceof GasStackIngredient) {
            this.initChemical(recipeLayout, recipe, MekanismJEI.TYPE_GAS, (GasStackIngredient)input, null);
        } else if (input instanceof InfusionStackIngredient) {
            this.initChemical(recipeLayout, recipe, MekanismJEI.TYPE_INFUSION, (InfusionStackIngredient)input, null);
        } else if (input instanceof PigmentStackIngredient) {
            this.initChemical(recipeLayout, recipe, MekanismJEI.TYPE_PIGMENT, (PigmentStackIngredient)input, null);
        } else if (input instanceof SlurryStackIngredient) {
            SlurryStackIngredient slurryInput = (SlurryStackIngredient)input;
            HashSet<ITag<Item>> tags = new HashSet<ITag<Item>>();
            for (SlurryStack slurryStack : slurryInput.getRepresentations()) {
                ITag<Item> oreTag;
                Slurry slurry = (Slurry)slurryStack.getType();
                if (slurry.isIn(MekanismTags.Slurries.DIRTY) || (oreTag = slurry.getOreTag()) == null) continue;
                tags.add(oreTag);
            }
            if (tags.size() == 1) {
                this.initChemical(recipeLayout, recipe, MekanismJEI.TYPE_SLURRY, slurryInput, itemStacks);
                tags.stream().findFirst().ifPresent(tag -> this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 1, false, this.slurryOreSlot, tag.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList())));
            } else {
                this.initChemical(recipeLayout, recipe, MekanismJEI.TYPE_SLURRY, slurryInput, null);
            }
        }
    }

    private <STACK extends ChemicalStack<?>> void initChemical(IRecipeLayout recipeLayout, ChemicalCrystallizerRecipe recipe, IIngredientType<STACK> type, IChemicalStackIngredient<?, STACK> ingredient, @Nullable IGuiItemStackGroup itemIngredientGroup) {
        IGuiIngredientGroup stacks = recipeLayout.getIngredientsGroup(type);
        this.initChemical(stacks, 0, true, this.gauge, ingredient.getRepresentations());
        this.ingredients.put(recipe, new IngredientTarget(stacks, itemIngredientGroup));
    }

    private static class OreInfo
    implements GuiChemicalCrystallizer.IOreInfo {
        @Nullable
        private ChemicalCrystallizerRecipe currentRecipe;
        @Nullable
        private IGuiIngredient<? extends ChemicalStack<?>> ingredient;
        @Nullable
        private IGuiIngredient<ItemStack> itemIngredient;

        private OreInfo() {
        }

        @Override
        @Nonnull
        public BoxedChemicalStack getInputChemical() {
            if (this.ingredient == null) {
                return BoxedChemicalStack.EMPTY;
            }
            ChemicalStack displayedIngredient = (ChemicalStack)this.ingredient.getDisplayedIngredient();
            return displayedIngredient == null || displayedIngredient.isEmpty() ? BoxedChemicalStack.EMPTY : BoxedChemicalStack.box(displayedIngredient);
        }

        @Override
        @Nullable
        public ChemicalCrystallizerRecipe getRecipe() {
            return this.currentRecipe;
        }

        @Override
        @Nonnull
        public ItemStack getRenderStack() {
            if (this.itemIngredient == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack displayedIngredient = (ItemStack)this.itemIngredient.getDisplayedIngredient();
            return displayedIngredient == null ? ItemStack.field_190927_a : displayedIngredient;
        }
    }

    private static class IngredientTarget {
        private final IGuiIngredientGroup<? extends ChemicalStack<?>> ingredientGroup;
        @Nullable
        private final IGuiItemStackGroup itemIngredientGroup;

        public IngredientTarget(IGuiIngredientGroup<? extends ChemicalStack<?>> ingredientGroup, @Nullable IGuiItemStackGroup itemIngredientGroup) {
            this.ingredientGroup = ingredientGroup;
            this.itemIngredientGroup = itemIngredientGroup;
        }
    }
}

