/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiPigmentMixer
extends GuiConfigurableTile<TileEntityPigmentMixer, MekanismTileContainer<TileEntityPigmentMixer>> {
    public GuiPigmentMixer(MekanismTileContainer<TileEntityPigmentMixer> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_238745_s_ += 2;
        this.field_238742_p_ = 5;
        this.field_238743_q_ = 5;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiHorizontalPowerBar((IGuiWrapper)this, ((TileEntityPigmentMixer)this.tile).getEnergyContainer(), 115, 75));
        this.func_230480_a_(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityPigmentMixer)this.tile).getEnergyContainer(), ((TileEntityPigmentMixer)this.tile)::getEnergyUsed));
        this.func_230480_a_(new GuiPigmentGauge(() -> ((TileEntityPigmentMixer)this.tile).leftInputTank, () -> ((TileEntityPigmentMixer)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 25, 13));
        this.func_230480_a_(new GuiPigmentGauge(() -> ((TileEntityPigmentMixer)this.tile).outputTank, () -> ((TileEntityPigmentMixer)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 79, 4));
        this.func_230480_a_(new GuiPigmentGauge(() -> ((TileEntityPigmentMixer)this.tile).rightInputTank, () -> ((TileEntityPigmentMixer)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 133, 13));
        this.func_230480_a_(((GuiProgress)new GuiProgress(((TileEntityPigmentMixer)this.tile)::getActive, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 47, 39).jeiCategory(this.tile)).colored(new LeftColorDetails()));
        this.func_230480_a_(((GuiProgress)new GuiProgress(((TileEntityPigmentMixer)this.tile)::getActive, ProgressType.SMALL_LEFT, (IGuiWrapper)this, 101, 39).jeiCategory(this.tile)).colored(new RightColorDetails()));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawString(matrix, ((TileEntityPigmentMixer)this.tile).getName(), this.field_238742_p_, this.field_238743_q_, this.titleTextColor());
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private abstract class PigmentColorDetails
    implements GuiProgress.ColorDetails {
        private WeakReference<PigmentMixingRecipe> cachedRecipe;

        private PigmentColorDetails() {
        }

        @Override
        public abstract int getColorFrom();

        @Override
        public int getColorTo() {
            if (GuiPigmentMixer.this.tile == null) {
                return -1;
            }
            if (((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).outputTank.isEmpty()) {
                if (!((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).leftInputTank.isEmpty() && !((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).rightInputTank.isEmpty()) {
                    PigmentMixingRecipe recipe;
                    PigmentStack leftInput = (PigmentStack)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).leftInputTank.getStack();
                    PigmentStack rightInput = (PigmentStack)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).rightInputTank.getStack();
                    if (this.cachedRecipe == null) {
                        recipe = this.getRecipeAndCache();
                    } else {
                        recipe = (PigmentMixingRecipe)this.cachedRecipe.get();
                        if (recipe == null || !this.isValid(recipe, leftInput, rightInput)) {
                            recipe = this.getRecipeAndCache();
                        }
                    }
                    if (recipe != null) {
                        return this.getColor(recipe.getOutput(leftInput, rightInput).getChemicalColorRepresentation());
                    }
                }
                return -1;
            }
            return this.getColor(((Pigment)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).outputTank.getType()).getColorRepresentation());
        }

        private PigmentMixingRecipe getRecipeAndCache() {
            PigmentMixingRecipe recipe = ((TileEntityPigmentMixer)GuiPigmentMixer.this.tile).getRecipe(0);
            this.cachedRecipe = recipe == null ? null : new WeakReference<PigmentMixingRecipe>(recipe);
            return recipe;
        }

        private boolean isValid(PigmentMixingRecipe recipe, PigmentStack leftInput, PigmentStack rightInput) {
            return ((PigmentStackIngredient)recipe.getLeftInput()).testType(leftInput) && ((PigmentStackIngredient)recipe.getRightInput()).testType(rightInput) || ((PigmentStackIngredient)recipe.getLeftInput()).testType(rightInput) && ((PigmentStackIngredient)recipe.getRightInput()).testType(leftInput);
        }

        protected int getColor(int tint) {
            if ((tint & 0xFF000000) == 0) {
                return 0xFF000000 | tint;
            }
            return tint;
        }
    }

    private class RightColorDetails
    extends PigmentColorDetails {
        private RightColorDetails() {
        }

        @Override
        public int getColorFrom() {
            return GuiPigmentMixer.this.tile == null ? -1 : this.getColor(((Pigment)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).rightInputTank.getType()).getColorRepresentation());
        }
    }

    private class LeftColorDetails
    extends PigmentColorDetails {
        private LeftColorDetails() {
        }

        @Override
        public int getColorFrom() {
            return GuiPigmentMixer.this.tile == null ? -1 : this.getColor(((Pigment)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).leftInputTank.getType()).getColorRepresentation());
        }
    }
}

