/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiThermalEvaporationController
extends GuiMekanismTile<TileEntityThermalEvaporationController, MekanismTileContainer<TileEntityThermalEvaporationController>> {
    public GuiThermalEvaporationController(MekanismTileContainer<TileEntityThermalEvaporationController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_238745_s_ += 2;
        this.field_238743_q_ = 4;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 48, 19, 80, 40, () -> {
            EvaporationMultiblockData multiblock = (EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock();
            return Arrays.asList(MekanismLang.MULTIBLOCK_FORMED.translate(new Object[0]), MekanismLang.EVAPORATION_HEIGHT.translate(multiblock.height()), MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(multiblock.getTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.FLUID_PRODUCTION.translate((double)Math.round(multiblock.lastGain * 100.0) / 100.0));
        }).spacing(1).jeiCategory(this.tile));
        this.func_230480_a_(new GuiDownArrow(this, 32, 39));
        this.func_230480_a_(new GuiDownArrow(this, 136, 39));
        this.func_230480_a_(new GuiHorizontalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismUtils.getTemperatureDisplay(((EvaporationMultiblockData)((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tile).getMultiblock()).getTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
            }

            @Override
            public double getLevel() {
                return Math.min(1.0, ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tile).getMultiblock()).getTemperature() / 3000.0);
            }
        }, 48, 63));
        this.func_230480_a_(new GuiFluidGauge(() -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).inputTank, () -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, this, 6, 13));
        this.func_230480_a_(new GuiFluidGauge(() -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).outputTank, () -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, this, 152, 13));
        this.func_230480_a_(new GuiHeatTab(this, () -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)MekanismLang.EVAPORATION_PLANT.translate(new Object[0]), this.field_238743_q_);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

