/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiSecurityLight;
import mekanism.client.gui.element.GuiTextureOnlyElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.to_server.PacketAddTrusted;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiSecurityDesk
extends GuiMekanismTile<TileEntitySecurityDesk, MekanismTileContainer<TileEntitySecurityDesk>> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private MekanismButton removeButton;
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton trustedButton;
    private MekanismButton overrideButton;
    private GuiTextScrollList scrollList;
    private GuiTextField trustedField;

    public GuiSecurityDesk(MekanismTileContainer<TileEntitySecurityDesk> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 64;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.field_238743_q_ = 4;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        this.func_230480_a_(new GuiElementHolder(this, 141, 13, 26, 37));
        this.func_230480_a_(new GuiElementHolder(this, 141, 54, 26, 34));
        this.func_230480_a_(new GuiElementHolder(this, 141, 92, 26, 37));
        super.addGuiElements();
        this.func_230480_a_(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 17));
        this.func_230480_a_(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 96));
        this.func_230480_a_(new GuiSecurityLight(this, 144, 77, () -> {
            SecurityFrequency frequency = ((TileEntitySecurityDesk)this.tile).getFreq();
            return frequency == null || ((TileEntitySecurityDesk)this.tile).ownerUUID == null || !((TileEntitySecurityDesk)this.tile).ownerUUID.equals(this.getMinecraft().field_71439_g.func_110124_au()) ? 2 : (frequency.isOverridden() ? 0 : 1);
        }));
        this.func_230480_a_(new GuiTextureOnlyElement(PUBLIC, this, 145, 32, 18, 18));
        this.func_230480_a_(new GuiTextureOnlyElement(PRIVATE, this, 145, 111, 18, 18));
        this.scrollList = (GuiTextScrollList)this.func_230480_a_(new GuiTextScrollList(this, 13, 13, 122, 42));
        this.removeButton = (MekanismButton)this.func_230480_a_(new TranslationButton(this, 13, 81, 122, 20, MekanismLang.BUTTON_REMOVE, () -> {
            int selection = this.scrollList.getSelection();
            if (((TileEntitySecurityDesk)this.tile).getFreq() != null && selection != -1) {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.REMOVE_TRUSTED, (TileEntity)this.tile, selection));
                this.scrollList.clearSelection();
                this.updateButtons();
            }
        }));
        this.trustedField = (GuiTextField)this.func_230480_a_(new GuiTextField(this, 35, 68, 99, 11));
        this.trustedField.setMaxStringLength(16);
        this.trustedField.setBackground(BackgroundType.INNER_SCREEN);
        this.trustedField.setEnterHandler(this::setTrusted);
        this.trustedField.setInputValidator(InputValidator.USERNAME);
        this.trustedField.addCheckmarkButton(this::setTrusted);
        this.publicButton = (MekanismButton)this.func_230480_a_(new MekanismImageButton(this, 13, 113, 40, 16, 40, 16, this.getButtonLocation("public"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, (TileEntity)this.tile, SecurityMode.PUBLIC.ordinal()));
            this.updateButtons();
        }, this.getOnHover(MekanismLang.PUBLIC_MODE)));
        this.privateButton = (MekanismButton)this.func_230480_a_(new MekanismImageButton(this, 54, 113, 40, 16, 40, 16, this.getButtonLocation("private"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, (TileEntity)this.tile, SecurityMode.PRIVATE.ordinal()));
            this.updateButtons();
        }, this.getOnHover(MekanismLang.PRIVATE_MODE)));
        this.trustedButton = (MekanismButton)this.func_230480_a_(new MekanismImageButton(this, 95, 113, 40, 16, 40, 16, this.getButtonLocation("trusted"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SECURITY_DESK_MODE, (TileEntity)this.tile, SecurityMode.TRUSTED.ordinal()));
            this.updateButtons();
        }, this.getOnHover(MekanismLang.TRUSTED_MODE)));
        this.overrideButton = (MekanismButton)this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, 146, 59, 16, 16, this.getButtonLocation("exclamation"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.OVERRIDE_BUTTON, this.tile));
            this.updateButtons();
        }, (onHover, matrix, xAxis, yAxis) -> {
            SecurityFrequency frequency = ((TileEntitySecurityDesk)this.tile).getFreq();
            if (frequency != null) {
                this.displayTooltip(matrix, (ITextComponent)MekanismLang.SECURITY_OVERRIDE.translate(BooleanStateDisplay.OnOff.of(frequency.isOverridden())), xAxis, yAxis);
            }
        }));
        this.updateButtons();
    }

    private void setTrusted() {
        SecurityFrequency freq = ((TileEntitySecurityDesk)this.tile).getFreq();
        if (freq != null && ((TileEntitySecurityDesk)this.tile).ownerUUID != null && ((TileEntitySecurityDesk)this.tile).ownerUUID.equals(this.getMinecraft().field_71439_g.func_110124_au())) {
            this.addTrusted(this.trustedField.getText());
            this.trustedField.setText("");
            this.updateButtons();
        }
    }

    private void addTrusted(String trusted) {
        if (PacketAddTrusted.validateNameLength(trusted.length())) {
            Mekanism.packetHandler.sendToServer(new PacketAddTrusted(((TileEntitySecurityDesk)this.tile).func_174877_v(), trusted));
        }
    }

    private void updateButtons() {
        SecurityFrequency freq = ((TileEntitySecurityDesk)this.tile).getFreq();
        if (((TileEntitySecurityDesk)this.tile).ownerUUID != null) {
            this.scrollList.setText(freq == null ? Collections.emptyList() : freq.getTrustedUsernameCache());
            this.removeButton.field_230693_o_ = this.scrollList.hasSelection();
        }
        if (freq != null && ((TileEntitySecurityDesk)this.tile).ownerUUID != null && ((TileEntitySecurityDesk)this.tile).ownerUUID.equals(this.getMinecraft().field_71439_g.func_110124_au())) {
            this.publicButton.field_230693_o_ = freq.getSecurityMode() != SecurityMode.PUBLIC;
            this.privateButton.field_230693_o_ = freq.getSecurityMode() != SecurityMode.PRIVATE;
            this.trustedButton.field_230693_o_ = freq.getSecurityMode() != SecurityMode.TRUSTED;
            this.overrideButton.field_230693_o_ = true;
        } else {
            this.publicButton.field_230693_o_ = false;
            this.privateButton.field_230693_o_ = false;
            this.trustedButton.field_230693_o_ = false;
            this.overrideButton.field_230693_o_ = false;
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateButtons();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        ITextComponent ownerComponent = OwnerDisplay.of(((TileEntitySecurityDesk)this.tile).ownerUUID, ((TileEntitySecurityDesk)this.tile).clientOwner).getTextComponent();
        this.drawString(matrix, ownerComponent, this.field_146999_f - 7 - this.getStringWidth(ownerComponent), this.field_238745_s_, this.titleTextColor());
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        this.drawCenteredText(matrix, (ITextComponent)MekanismLang.TRUSTED_PLAYERS.translate(new Object[0]), 74.0f, 57.0f, this.subheadingTextColor());
        SecurityFrequency frequency = ((TileEntitySecurityDesk)this.tile).getFreq();
        if (frequency != null) {
            this.drawString(matrix, (ITextComponent)MekanismLang.SECURITY.translate(frequency.getSecurityMode()), 13, 103, this.titleTextColor());
        } else {
            this.drawString(matrix, (ITextComponent)MekanismLang.SECURITY_OFFLINE.translateColored(EnumColor.RED, new Object[0]), 13, 103, this.titleTextColor());
        }
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.SECURITY_ADD.translate(new Object[0]), 13.0f, 70.0f, this.titleTextColor(), 20.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

