/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.integration.DrawerOverlay;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TheOneProbe
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        if (((Boolean)ClientConfig.INTEGRATION.enableTheOneProbe.get()).booleanValue()) {
            probe.registerProvider((IProbeInfoProvider)new DrawerProbeProvider());
        }
        return null;
    }

    private static class DrawerProbeProvider
    implements IProbeInfoProvider {
        private DrawerProbeProvider() {
        }

        public String getID() {
            return new ResourceLocation("storagedrawers", "drawerprobe").toString();
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probe, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
            TileEntity tile = world.func_175625_s(data.getPos());
            if (tile instanceof TileEntityDrawers) {
                TileEntityDrawers drawers = (TileEntityDrawers)tile;
                DrawerOverlay overlay = new DrawerOverlay();
                for (ITextComponent component : overlay.getOverlay(drawers)) {
                    probe.text(component);
                }
            }
        }
    }
}

