/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.ChamTileEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.ItemCollectionRegistry;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityController
extends ChamTileEntity
implements IDrawerGroup {
    @CapabilityInject(value=IDrawerAttributes.class)
    public static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private static final int PRI_LOCKED = 0;
    private static final int PRI_LOCKED_VOID = 1;
    private static final int PRI_NORMAL = 2;
    private static final int PRI_VOID = 3;
    private static final int PRI_EMPTY = 4;
    private static final int PRI_LOCKED_EMPTY = 5;
    private static final int PRI_DISABLED = 6;
    private Queue<BlockPos> searchQueue = new LinkedList<BlockPos>();
    private Set<BlockPos> searchDiscovered = new HashSet<BlockPos>();
    private Comparator<SlotRecord> slotRecordComparator = (o1, o2) -> o1.priority - o2.priority;
    private Map<BlockPos, StorageRecord> storage = new HashMap<BlockPos, StorageRecord>();
    protected List<SlotRecord> drawerSlotList = new ArrayList<SlotRecord>();
    private ItemCollectionRegistry<SlotRecord> drawerPrimaryLookup = new ItemCollectionRegistry();
    protected int[] drawerSlots = new int[0];
    private int range;
    private long lastUpdateTime;
    private long lastClickTime;
    private UUID lastClickUUID;
    @CapabilityInject(value=IItemHandler.class)
    static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IItemRepository.class)
    static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    @CapabilityInject(value=IDrawerGroup.class)
    static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;
    private final DrawerItemHandler itemHandler = new DrawerItemHandler(this);
    private final ItemRepository itemRepository = new ItemRepository(this);
    private final LazyOptional<?> capabilityItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<?> capabilityItemRepository = LazyOptional.of(() -> this.itemRepository);
    private final LazyOptional<?> capabilityGroup = LazyOptional.of(() -> this);

    private IDrawerAttributes getAttributes(Object obj) {
        IDrawerAttributes attrs = EmptyDrawerAttributes.EMPTY;
        if (obj instanceof ICapabilityProvider) {
            attrs = (IDrawerAttributes)((ICapabilityProvider)obj).getCapability(DRAWER_ATTRIBUTES_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        }
        return attrs;
    }

    private int getSlotPriority(SlotRecord record) {
        IDrawerGroup group = this.getGroupForSlotRecord(record);
        if (group == null) {
            return 6;
        }
        int drawerSlot = record.slot;
        IDrawer drawer = group.getDrawer(drawerSlot);
        if (!drawer.isEnabled()) {
            return 6;
        }
        IDrawerAttributes attrs = this.getAttributes(group);
        if (drawer.isEmpty()) {
            if (attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return 5;
            }
            return 4;
        }
        if (attrs.isVoid()) {
            if (attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                return 1;
            }
            return 3;
        }
        if (attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            return 0;
        }
        return 2;
    }

    protected TileEntityController(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.range = (Integer)CommonConfig.GENERAL.controllerRange.get();
    }

    public TileEntityController() {
        this(ModBlocks.Tile.CONTROLLER);
    }

    public void printDebugInfo() {
        StorageDrawers.log.info("Controller at " + this.field_174879_c.toString());
        StorageDrawers.log.info("  Range: " + this.range + " blocks");
        StorageDrawers.log.info("  Stored records: " + this.storage.size() + ", slot list: " + this.drawerSlots.length);
        StorageDrawers.log.info("  Ticks since last update: " + (this.func_145831_w().func_82737_E() - this.lastUpdateTime));
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.func_145831_w().func_205220_G_().func_205359_a(this.func_174877_v(), (Object)ModBlocks.CONTROLLER)) {
            this.func_145831_w().func_205220_G_().func_205362_a(this.func_174877_v(), (Object)ModBlocks.CONTROLLER, 1, TickPriority.NORMAL);
        }
    }

    @Override
    public boolean isGroupValid() {
        return !this.func_145837_r();
    }

    public int interactPutItemsIntoInventory(PlayerEntity player) {
        boolean dumpInventory = this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.func_110124_au().equals(this.lastClickUUID);
        int count = 0;
        if (!dumpInventory) {
            ItemStack currentStack = player.field_71071_by.func_70448_g();
            if (!currentStack.func_190926_b()) {
                count = this.insertItems(currentStack, player.func_146103_bH());
                if (currentStack.func_190916_E() == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
        } else {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack.func_190926_b()) continue;
                count += this.insertItems(subStack, player.func_146103_bH());
                if (subStack.func_190916_E() != 0) continue;
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (count > 0) {
                StorageDrawers.proxy.updatePlayerInventory(player);
            }
        }
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.func_110124_au();
        return count;
    }

    protected int insertItems(@Nonnull ItemStack stack, GameProfile profile) {
        int remainder = new ProtectedItemRepository(this, profile).insertItem(stack, false).func_190916_E();
        int added = stack.func_190916_E() - remainder;
        stack.func_190920_e(remainder);
        return added;
    }

    public void toggleProtection(GameProfile profile, ISecurityProvider provider) {
        IProtectable template = null;
        UUID state = null;
        for (StorageRecord record : this.storage.values()) {
            IProtectable protectable;
            if (record.storage == null || !(record.storage instanceof IProtectable) || !SecurityManager.hasOwnership(profile, protectable = (IProtectable)((Object)record.storage))) continue;
            if (template == null) {
                template = protectable;
                if (template.getOwner() == null) {
                    state = profile.getId();
                } else {
                    state = null;
                    provider = null;
                }
            }
            protectable.setOwner(state);
            protectable.setSecurityProvider(provider);
        }
    }

    public void toggleShroud(GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerAttributes attrs;
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage)) || !((attrs = this.getAttributes(record.storage)) instanceof IDrawerAttributesModifiable)) continue;
            IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
            if (template == null) {
                template = mattrs.isConcealed();
                state = template == false;
            }
            mattrs.setIsConcealed(state);
        }
    }

    public void toggleQuantified(GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerAttributes attrs;
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage)) || !((attrs = this.getAttributes(record.storage)) instanceof IDrawerAttributesModifiable)) continue;
            IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
            if (template == null) {
                template = mattrs.isShowingQuantity();
                state = template == false;
            }
            mattrs.setIsShowingQuantity(state);
        }
    }

    public void toggleLock(EnumSet<LockAttribute> attributes, LockAttribute key, GameProfile profile) {
        Boolean template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerAttributes attrs;
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage)) || !((attrs = this.getAttributes(record.storage)) instanceof IDrawerAttributesModifiable)) continue;
            IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
            if (template == null) {
                template = mattrs.isItemLocked(key);
                state = template == false;
            }
            for (LockAttribute attr : attributes) {
                mattrs.setItemLocked(attr, state);
            }
        }
    }

    protected void resetCache() {
        this.storage.clear();
        this.drawerSlotList.clear();
    }

    public boolean isValidSlave(BlockPos coord) {
        StorageRecord record = this.storage.get(coord);
        if (record == null || !record.mark) {
            return false;
        }
        return record.storage == null;
    }

    public void updateCache() {
        this.lastUpdateTime = this.func_145831_w().func_82737_E();
        int preCount = this.drawerSlots.length;
        this.resetCache();
        this.populateNodes(this.func_174877_v());
        this.flattenLists();
        this.drawerSlots = this.sortSlotRecords(this.drawerSlotList);
        this.rebuildPrimaryLookup(this.drawerPrimaryLookup, this.drawerSlotList);
        if (!(preCount == this.drawerSlots.length || preCount != 0 && this.drawerSlots.length != 0 || this.func_145831_w().field_72995_K)) {
            this.func_70296_d();
        }
    }

    private void indexSlotRecords(List<SlotRecord> records) {
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            SlotRecord record = records.get(i);
            if (record == null) continue;
            record.index = i;
            record.priority = this.getSlotPriority(record);
        }
    }

    private int[] sortSlotRecords(List<SlotRecord> records) {
        this.indexSlotRecords(records);
        ArrayList<SlotRecord> copied = new ArrayList<SlotRecord>(records);
        Collections.sort(copied, this.slotRecordComparator);
        int[] slotMap = new int[copied.size()];
        for (int i = 0; i < slotMap.length; ++i) {
            slotMap[i] = ((SlotRecord)copied.get((int)i)).index;
        }
        return slotMap;
    }

    private void rebuildPrimaryLookup(ItemCollectionRegistry<SlotRecord> lookup, List<SlotRecord> records) {
        lookup.clear();
        for (SlotRecord record : records) {
            int drawerSlot;
            IDrawer drawer;
            IDrawerGroup group = this.getGroupForSlotRecord(record);
            if (group == null || !(drawer = group.getDrawer(drawerSlot = record.slot)).isEnabled() || drawer.isEmpty()) continue;
            ItemStack item = drawer.getStoredItemPrototype();
            lookup.register(item.func_77973_b(), record);
        }
    }

    private boolean containsNullEntries(List<SlotRecord> list) {
        int nullCount = 0;
        for (SlotRecord aList : list) {
            if (aList != null) continue;
            ++nullCount;
        }
        return nullCount > 0;
    }

    private void flattenLists() {
        if (this.containsNullEntries(this.drawerSlotList)) {
            ArrayList<SlotRecord> newDrawerSlotList = new ArrayList<SlotRecord>();
            for (SlotRecord record : this.drawerSlotList) {
                if (record == null) continue;
                newDrawerSlotList.add(record);
            }
            this.drawerSlotList = newDrawerSlotList;
        }
    }

    private void clearRecordInfo(BlockPos coord, StorageRecord record) {
        record.clear();
        for (int i = 0; i < this.drawerSlotList.size(); ++i) {
            SlotRecord slotRecord = this.drawerSlotList.get(i);
            if (slotRecord == null || !coord.equals((Object)slotRecord.coord)) continue;
            this.drawerSlotList.set(i, null);
        }
    }

    private void updateRecordInfo(BlockPos coord, StorageRecord record, TileEntity te) {
        if (te == null) {
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            return;
        }
        if (te instanceof TileEntityController) {
            if (record.storage == null && record.invStorageSize > 0) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
        } else if (te instanceof TileEntitySlave) {
            if (record.storage == null && record.invStorageSize == 0 && ((TileEntitySlave)te).getController() == this) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            ((TileEntitySlave)te).bindController(this.func_174877_v());
        } else if (te instanceof TileEntityDrawers) {
            IDrawerGroup group = ((TileEntityDrawers)te).getGroup();
            if (record.storage == group) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        } else {
            IDrawerGroup group = (IDrawerGroup)te.getCapability(DRAWER_GROUP_CAPABILITY, null).orElse(null);
            if (record.storage == group) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            if (group == null) {
                return;
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        }
    }

    private void populateNodes(BlockPos root) {
        this.searchQueue.clear();
        this.searchQueue.add(root);
        this.searchDiscovered.clear();
        this.searchDiscovered.add(root);
        while (!this.searchQueue.isEmpty()) {
            BlockPos[] neighbors;
            Block block;
            BlockPos coord = this.searchQueue.remove();
            int depth = Math.max(Math.max(Math.abs(coord.func_177958_n() - root.func_177958_n()), Math.abs(coord.func_177956_o() - root.func_177956_o())), Math.abs(coord.func_177952_p() - root.func_177952_p()));
            if (depth > this.range || !this.func_145831_w().func_175667_e(coord) || !((block = this.func_145831_w().func_180495_p(coord).func_177230_c()) instanceof INetworked)) continue;
            StorageRecord record = this.storage.get(coord);
            if (record == null) {
                record = new StorageRecord();
                this.storage.put(coord, record);
            }
            if (block instanceof BlockSlave) {
                ((BlockSlave)block).getTileEntitySafe(this.func_145831_w(), coord);
            }
            this.updateRecordInfo(coord, record, this.func_145831_w().func_175625_s(coord));
            record.mark = true;
            record.distance = depth;
            for (BlockPos n : neighbors = new BlockPos[]{coord.func_177976_e(), coord.func_177974_f(), coord.func_177968_d(), coord.func_177978_c(), coord.func_177984_a(), coord.func_177977_b()}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
    }

    protected IDrawerGroup getGroupForDrawerSlot(int drawerSlot) {
        if (drawerSlot < 0 || drawerSlot >= this.drawerSlotList.size()) {
            return null;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForSlotRecord(record);
    }

    protected IDrawerGroup getGroupForSlotRecord(SlotRecord record) {
        TileEntity tile;
        IDrawerGroup group = record.group;
        if (group == null || !group.isGroupValid()) {
            return null;
        }
        if (group instanceof TileEntity && ((tile = (TileEntity)group).func_145837_r() || !tile.func_174877_v().equals((Object)record.coord))) {
            record.group = null;
            return null;
        }
        return group;
    }

    private int getLocalDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    @Override
    public void readFixed(CompoundNBT tag) {
        super.readFixed(tag);
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.updateCache();
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    public int getDrawerCount() {
        return this.drawerSlotList.size();
    }

    @Override
    @Nonnull
    public IDrawer getDrawer(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return Drawers.DISABLED;
        }
        return group.getDrawer(this.getLocalDrawerSlot(slot));
    }

    @Override
    @Nonnull
    public int[] getAccessibleDrawerSlots() {
        return this.drawerSlots;
    }

    public IItemRepository getItemRepository() {
        return this.itemRepository;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.capabilityItemHandler.cast();
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return this.capabilityItemRepository.cast();
        }
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return this.capabilityGroup.cast();
        }
        return super.getCapability(capability, facing);
    }

    private class ProtectedItemRepository
    extends ItemRepository {
        private GameProfile profile;

        public ProtectedItemRepository(IDrawerGroup group, GameProfile profile) {
            super(group);
            this.profile = profile;
        }

        @Override
        protected boolean hasAccess(IDrawerGroup group, IDrawer drawer) {
            if (drawer.isEmpty()) {
                return false;
            }
            if (group instanceof IProtectable) {
                return SecurityManager.hasAccess(this.profile, (IProtectable)((Object)group));
            }
            return true;
        }
    }

    private class ItemRepository
    extends DrawerItemRepository {
        public ItemRepository(IDrawerGroup group) {
            super(group);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            Collection primaryRecords = TileEntityController.this.drawerPrimaryLookup.getEntries(stack.func_77973_b());
            HashSet<Integer> checkedSlots = simulate ? new HashSet<Integer>() : null;
            int amount = stack.func_190916_E();
            if (primaryRecords != null) {
                for (SlotRecord record : primaryRecords) {
                    IDrawer drawer;
                    IDrawerGroup candidateGroup = TileEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || (drawer = candidateGroup.getDrawer(record.slot)).isEmpty() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer)) continue;
                    int n = amount = simulate ? Math.max(amount - drawer.getAcceptingRemainingCapacity(), 0) : drawer.adjustStoredItemCount(amount);
                    if (amount == 0) {
                        return ItemStack.field_190927_a;
                    }
                    if (!simulate) continue;
                    checkedSlots.add(record.index);
                }
            }
            for (Object slot : (Object)TileEntityController.this.drawerSlots) {
                IDrawer drawer = TileEntityController.this.getDrawer((int)slot);
                if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(TileEntityController.this.getGroupForDrawerSlot((int)slot), drawer) || simulate && checkedSlots.contains((int)slot)) continue;
                boolean empty = drawer.isEmpty();
                if (empty && !simulate) {
                    drawer = drawer.setStoredItem(stack);
                }
                int n = simulate ? Math.max(amount - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (amount = drawer.adjustStoredItemCount(amount));
                if (amount != 0) continue;
                return ItemStack.field_190927_a;
            }
            return this.stackResult(stack, amount);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            Collection primaryRecords = TileEntityController.this.drawerPrimaryLookup.getEntries(stack.func_77973_b());
            HashSet<Integer> checkedSlots = simulate ? new HashSet<Integer>() : null;
            int remaining = amount;
            if (primaryRecords != null) {
                for (SlotRecord record : primaryRecords) {
                    IDrawer drawer;
                    IDrawerGroup candidateGroup = TileEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || !(drawer = candidateGroup.getDrawer(record.slot)).isEnabled() || !this.testPredicateExtract(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer)) continue;
                    int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
                    if (remaining == 0) {
                        return this.stackResult(stack, amount);
                    }
                    if (!simulate) continue;
                    checkedSlots.add(record.index);
                }
            }
            for (Object slot : (Object)TileEntityController.this.drawerSlots) {
                IDrawer drawer = TileEntityController.this.getDrawer((int)slot);
                if (!drawer.isEnabled() || !this.testPredicateExtract(drawer, stack, predicate) || simulate && checkedSlots.contains((int)slot)) continue;
                int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
                if (remaining != 0) continue;
                return this.stackResult(stack, amount);
            }
            return amount == remaining ? ItemStack.field_190927_a : this.stackResult(stack, amount - remaining);
        }

        protected boolean hasAccess(IDrawerGroup group, IDrawer drawer) {
            return true;
        }
    }

    protected static class SlotRecord
    implements Comparable<SlotRecord> {
        public BlockPos coord;
        public IDrawerGroup group;
        public int slot;
        public int index;
        public int priority;

        public SlotRecord(IDrawerGroup group, BlockPos coord, int slot) {
            this.group = group;
            this.coord = coord;
            this.slot = slot;
        }

        @Override
        public int compareTo(SlotRecord other) {
            int diff = this.priority - other.priority;
            if (diff == 0) {
                diff = this.coord.compareTo((Vector3i)other.coord);
                if (diff == 0) {
                    return this.index - other.index;
                }
                return diff;
            }
            return diff;
        }
    }

    private static class StorageRecord {
        public IDrawerGroup storage;
        public boolean mark;
        public int invStorageSize;
        public int drawerStorageSize;
        public int distance = Integer.MAX_VALUE;

        private StorageRecord() {
        }

        public void clear() {
            this.storage = null;
            this.mark = false;
            this.invStorageSize = 0;
            this.drawerStorageSize = 0;
            this.distance = Integer.MAX_VALUE;
        }
    }
}

