/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.container.ControllerContainer;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.tile.ClientNode;
import com.refinedmods.refinedstorage.tile.ControllerTile;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class ControllerScreen
extends BaseScreen<ControllerContainer> {
    private static final int VISIBLE_ROWS = 2;
    private static final int ENERGY_BAR_X = 8;
    private static final int ENERGY_BAR_Y = 20;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 59;
    private final ScrollbarWidget scrollbar = new ScrollbarWidget(this, 157, 20, 12, 59);

    public ControllerScreen(ControllerContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 176, 181, inventory, title);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, ControllerTile.REDSTONE_MODE));
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() > 2);
        this.scrollbar.setMaxOffset(this.getRows() - 2);
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/controller.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int energyBarHeightNew = Network.getEnergyScaled(ControllerTile.ENERGY_STORED.getValue(), ControllerTile.ENERGY_CAPACITY.getValue(), 59);
        this.func_238474_b_(matrixStack, x + 8, y + 20 + 59 - energyBarHeightNew, 178, 59 - energyBarHeightNew, 16, energyBarHeightNew);
        this.scrollbar.render(matrixStack);
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean func_231044_a_(double mx, double my, int button) {
        return this.scrollbar.func_231044_a_(mx, my, button) || super.func_231044_a_(mx, my, button);
    }

    public boolean func_231048_c_(double mx, double my, int button) {
        return this.scrollbar.func_231048_c_(mx, my, button) || super.func_231048_c_(mx, my, button);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        return this.scrollbar.func_231043_a_(x, y, delta) || super.func_231043_a_(x, y, delta);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, 87, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        int x = 33;
        int y = 26;
        int slot = this.scrollbar.getOffset() * 2;
        RenderHelper.func_227784_d_();
        List<ClientNode> nodes = ControllerTile.NODES.getValue();
        ClientNode hoveringNode = null;
        for (int i = 0; i < 4; ++i) {
            if (slot < nodes.size()) {
                ClientNode node = nodes.get(slot);
                this.renderItem(matrixStack, x, y + 5, node.getStack());
                float scale = this.field_230706_i_.func_211821_e() ? 1.0f : 0.5f;
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(scale, scale, 1.0f);
                this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 1, scale), RenderUtils.getOffsetOnScale(y - 2, scale), this.trimNameIfNeeded(!this.field_230706_i_.func_211821_e(), node.getStack().func_200301_q().getString()));
                this.renderString(matrixStack, RenderUtils.getOffsetOnScale(x + 21, scale), RenderUtils.getOffsetOnScale(y + 10, scale), node.getAmount() + "x");
                matrixStack.func_227865_b_();
                if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY)) {
                    hoveringNode = node;
                }
            }
            if (i == 1) {
                x = 33;
                y += 30;
            } else {
                x += 60;
            }
            ++slot;
        }
        if (hoveringNode != null) {
            this.renderTooltip(matrixStack, mouseX, mouseY, I18n.func_135052_a((String)"misc.refinedstorage.energy_usage_minimal", (Object[])new Object[]{hoveringNode.getEnergyUsage()}));
        }
        if (RenderUtils.inBounds(8, 20, 16, 59, mouseX, mouseY)) {
            this.renderTooltip(matrixStack, mouseX, mouseY, I18n.func_135052_a((String)"misc.refinedstorage.energy_usage", (Object[])new Object[]{ControllerTile.ENERGY_USAGE.getValue()}) + "\n" + I18n.func_135052_a((String)"misc.refinedstorage.energy_stored", (Object[])new Object[]{ControllerTile.ENERGY_STORED.getValue(), ControllerTile.ENERGY_CAPACITY.getValue()}));
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)ControllerTile.NODES.getValue().size() / 2.0f));
    }

    private String trimNameIfNeeded(boolean scaled, String name) {
        int max;
        int n = max = scaled ? 20 : 13;
        if (name.length() > max) {
            name = name.substring(0, max) + "...";
        }
        return name;
    }
}

