/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.GridFactoryType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.IGridFactory;
import com.refinedmods.refinedstorage.api.network.grid.IGridManager;
import com.refinedmods.refinedstorage.container.factory.GridContainerProvider;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class GridManager
implements IGridManager {
    private final Map<ResourceLocation, IGridFactory> factories = new HashMap<ResourceLocation, IGridFactory>();

    @Override
    public void add(ResourceLocation id, IGridFactory factory) {
        this.factories.put(id, factory);
    }

    @Override
    public void openGrid(ResourceLocation id, ServerPlayerEntity player, BlockPos pos) {
        this.openGrid(id, player, null, pos, new PlayerSlot(-1));
    }

    @Override
    public void openGrid(ResourceLocation id, ServerPlayerEntity player, ItemStack stack, PlayerSlot slot) {
        this.openGrid(id, player, stack, null, slot);
    }

    private void openGrid(ResourceLocation id, ServerPlayerEntity player, @Nullable ItemStack stack, @Nullable BlockPos pos, PlayerSlot slot) {
        Pair<IGrid, TileEntity> grid = this.createGrid(id, (PlayerEntity)player, stack, pos, slot);
        if (grid == null) {
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new GridContainerProvider((IGrid)grid.getLeft(), (TileEntity)grid.getRight()), buf -> {
            buf.func_192572_a(id);
            buf.writeBoolean(pos != null);
            if (pos != null) {
                buf.func_179255_a(pos);
            }
            buf.writeBoolean(stack != null);
            if (stack != null) {
                buf.func_150788_a(stack);
            }
            slot.writePlayerSlot((PacketBuffer)buf);
        });
    }

    @Override
    @Nullable
    public Pair<IGrid, TileEntity> createGrid(ResourceLocation id, PlayerEntity player, @Nullable ItemStack stack, @Nullable BlockPos pos, PlayerSlot slot) {
        IGridFactory factory = this.factories.get(id);
        if (factory == null) {
            return null;
        }
        IGrid grid = null;
        TileEntity tile = factory.getRelevantTile(player.field_70170_p, pos);
        if (factory.getType() == GridFactoryType.STACK) {
            grid = factory.createFromStack(player, stack, slot);
        } else if (factory.getType() == GridFactoryType.BLOCK) {
            grid = factory.createFromBlock(player, pos);
        }
        if (grid == null) {
            return null;
        }
        return Pair.of((Object)grid, (Object)tile);
    }
}

