/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.SerializationUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.CraftingNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeListener;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeRequirements;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingNode;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

public abstract class Node {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_ROOT = "Root";
    private static final String NBT_IS_PROCESSING = "IsProcessing";
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_QUANTITY_TOTAL = "TotalQuantity";
    private final boolean root;
    private final ICraftingPattern pattern;
    protected int quantity;
    protected int totalQuantity;
    protected final NodeRequirements requirements = new NodeRequirements();

    protected Node(ICraftingPattern pattern, boolean root) {
        this.pattern = pattern;
        this.root = root;
    }

    protected Node(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        this.quantity = tag.func_74762_e(NBT_QUANTITY);
        this.totalQuantity = tag.func_74762_e(NBT_QUANTITY_TOTAL);
        this.pattern = SerializationUtil.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.getWorld());
        this.root = tag.func_74767_n(NBT_ROOT);
        this.requirements.readFromNbt(tag);
    }

    public static Node fromNbt(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        return tag.func_74767_n(NBT_IS_PROCESSING) ? new ProcessingNode(network, tag) : new CraftingNode(network, tag);
    }

    public abstract void update(INetwork var1, int var2, NodeList var3, IStorageDisk<ItemStack> var4, IStorageDisk<FluidStack> var5, NodeListener var6);

    public void onCalculationFinished() {
        this.totalQuantity = this.quantity;
    }

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void addQuantity(int quantity) {
        this.quantity += quantity;
    }

    protected void next() {
        --this.quantity;
    }

    public boolean isRoot() {
        return this.root;
    }

    public NodeRequirements getRequirements() {
        return this.requirements;
    }

    public CompoundNBT writeToNbt() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(NBT_QUANTITY, this.quantity);
        tag.func_74768_a(NBT_QUANTITY_TOTAL, this.totalQuantity);
        tag.func_74757_a(NBT_IS_PROCESSING, this instanceof ProcessingNode);
        tag.func_74757_a(NBT_ROOT, this.root);
        tag.func_218657_a(NBT_PATTERN, (INBT)SerializationUtil.writePatternToNbt(this.pattern));
        tag = this.requirements.writeToNbt(tag);
        return tag;
    }
}

