/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.explosive;

import cofh.core.network.packet.client.PlayerMotionPacket;
import cofh.lib.entity.AbstractGrenadeEntity;
import cofh.lib.entity.AbstractTNTEntity;
import cofh.lib.entity.AbstractTNTMinecartEntity;
import cofh.lib.entity.BlackHoleEntity;
import cofh.lib.entity.ElectricFieldEntity;
import cofh.lib.util.AreaUtils;
import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.item.PhytoGroItem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class DetonateUtils {
    public static List<RegistryObject<EntityType<? extends AbstractGrenadeEntity>>> GRENADES = new LinkedList<RegistryObject<EntityType<? extends AbstractGrenadeEntity>>>();
    public static List<RegistryObject<EntityType<? extends AbstractTNTEntity>>> TNT = new LinkedList<RegistryObject<EntityType<? extends AbstractTNTEntity>>>();
    public static List<RegistryObject<EntityType<? extends AbstractTNTMinecartEntity>>> CARTS = new LinkedList<RegistryObject<EntityType<? extends AbstractTNTMinecartEntity>>>();

    public static void makeAreaOfEffectCloud(World level, IParticleData particle, Vector3d pos, float radius, int duration) {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(level, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a(particle);
        cloud.func_184486_b(duration);
        cloud.func_184485_d(0);
        cloud.func_184487_c((radius - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        level.func_217376_c((Entity)cloud);
    }

    public static void makeAreaOfEffectCloud(World level, IParticleData particle, Vector3d pos, float radius) {
        DetonateUtils.makeAreaOfEffectCloud(level, particle, pos, radius, 20);
    }

    public static void fire(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        if (!explosive.func_70090_H()) {
            AreaUtils.igniteEntities.applyEffectNearby(level, pos, radius, duration, amplifier);
            AreaUtils.fireTransformSpecial.transformSphere(level, pos, radius, 0.6f, owner);
            AreaUtils.fireTransform.transformSphere(level, pos, radius, 0.2f, owner);
            DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)ParticleTypes.field_197631_x, pos, radius);
        }
    }

    public static void ice(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        AreaUtils.iceTransform.transformSphere(level, pos, radius, owner);
        AreaUtils.chillEntities.applyEffectNearby(level, pos, radius, duration, amplifier);
        DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)CoreReferences.FROST_PARTICLE, pos, radius);
    }

    public static void earth(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        AreaUtils.earthTransform.transformSphere(level, pos, radius, owner);
        AreaUtils.sunderEntities.applyEffectNearby(level, pos, radius, duration, amplifier);
    }

    public static void lightning(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        BlockPos blockPos = new BlockPos(pos);
        if (level.func_226660_f_(blockPos)) {
            Utils.spawnLightningBolt((World)level, (BlockPos)blockPos, (Entity)owner);
        }
        AreaUtils.shockEntities.applyEffectNearby(level, pos, radius, duration, amplifier);
        level.func_217376_c((Entity)new ElectricFieldEntity(level, pos, radius, 100).setOwner(owner instanceof LivingEntity ? (LivingEntity)owner : null));
    }

    public static void ender(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        if (!explosive.func_70090_H()) {
            AreaUtils.enderAirTransform.transformSphere(level, pos, radius, owner);
            AreaUtils.enderfereEntities.applyEffectNearby(level, pos, radius, duration, amplifier);
            DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)ParticleTypes.field_197599_J, pos, radius);
        }
    }

    public static void glow(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        AreaUtils.glowAirTransform.transformSphere(level, pos, radius, explosive);
        AreaUtils.glowEntities.applyEffectNearby(level, pos, radius, duration, amplifier);
        DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)ParticleTypes.field_197590_A, pos, radius);
    }

    public static void redstone(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        AreaUtils.signalAirTransform.transformSphere(level, pos, radius, owner);
        DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)RedstoneParticleData.field_197564_a, pos, radius);
    }

    public static void slime(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        BlockPos blockPos = new BlockPos(pos);
        AxisAlignedBB area = new AxisAlignedBB(blockPos.func_177963_a((double)(-radius), (double)(-radius), (double)(-radius)), blockPos.func_177963_a((double)(1.0f + radius), (double)(1.0f + radius), (double)(1.0f + radius)));
        for (LivingEntity mob : level.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a)) {
            double d9;
            double d7;
            mob.func_195064_c(new EffectInstance(CoreReferences.SLIMED, duration, amplifier, false, true));
            double d5 = mob.func_226277_ct_() - explosive.func_226277_ct_();
            double d13 = MathHelper.func_76133_a((double)(d5 * d5 + (d7 = mob.func_226278_cu_() - explosive.func_226278_cu_()) * d7 + (d9 = mob.func_226281_cx_() - explosive.func_226281_cx_()) * d9));
            if (d13 == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d12 = Math.sqrt(explosive.func_70068_e((Entity)mob) / 32.0);
            double d14 = Explosion.func_222259_a((Vector3d)explosive.func_213303_ch(), (Entity)mob);
            double d11 = ((double)radius - d12) * d14;
            d11 *= 1.0 - mob.func_233637_b_(Attributes.field_233820_c_);
            if (mob instanceof ServerPlayerEntity) {
                PlayerMotionPacket.sendToClient((double)(d5 * (d11 /= 4.0)), (double)(d7 * d11), (double)(d9 * d11), (ServerPlayerEntity)((ServerPlayerEntity)mob));
                continue;
            }
            mob.func_213317_d(mob.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
        }
        DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)ParticleTypes.field_197592_C, pos, radius);
    }

    public static void phyto(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        AreaUtils.growPlants.transformSphere(level, pos, radius, owner);
        for (int i = 0; i < 2; ++i) {
            PhytoGroItem.growSeagrass(level, explosive.func_233580_cy_(), null);
        }
        DetonateUtils.makeAreaOfEffectCloud(level, (IParticleData)ParticleTypes.field_197632_y, pos, radius);
    }

    public static void explosive(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        boolean explosionsBreakBlocks = true;
        level.func_217398_a(explosive, explosive.func_226277_ct_(), explosive.func_226278_cu_(), explosive.func_226281_cx_(), 1.9f, false, explosionsBreakBlocks ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
    }

    public static void nuke(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        boolean explosionsBreakBlocks = true;
        level.func_175656_a(explosive.func_233580_cy_(), Blocks.field_150350_a.func_176223_P());
        if (radius <= 0.0f) {
            return;
        }
        float entityRadius = radius * 3.0f;
        BlockPos blockPos = new BlockPos(pos);
        AxisAlignedBB area = new AxisAlignedBB(blockPos.func_177963_a((double)(-entityRadius), (double)(-entityRadius), (double)(-entityRadius)), blockPos.func_177963_a((double)(1.0f + entityRadius), (double)(1.0f + entityRadius), (double)(1.0f + entityRadius)));
        double entityRadiusSqr = entityRadius * entityRadius;
        level.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a).forEach(target -> {
            double distSqr = pos.func_72436_e(target.func_213303_ch());
            if (distSqr < entityRadiusSqr) {
                float damage = (float)MathHelper.func_151237_a((double)(entityRadiusSqr - distSqr), (double)entityRadius, (double)entityRadiusSqr);
                target.func_70097_a(DamageSource.func_188405_b((LivingEntity)(owner instanceof LivingEntity ? (LivingEntity)owner : null)), damage);
                target.func_195064_c(new EffectInstance(Effects.field_82731_v, duration, amplifier, false, false));
            }
        });
        float blockRadius = radius * 2.0f;
        float f = Math.min(32.0f, blockRadius);
        float maxResistance = 400.0f * blockRadius * blockRadius;
        float f2 = f * f;
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)blockPos.func_177963_a((double)(-f), (double)(-f / 2.0f), (double)(-f)), (BlockPos)blockPos.func_177963_a((double)f, (double)f, (double)f))) {
            BlockState state;
            double distance = iterPos.func_218138_a((IPosition)explosive.func_213303_ch(), true);
            if (!(distance < (double)f2) || (state = level.func_180495_p(iterPos)).isAir((IBlockReader)level, iterPos) || !((double)state.func_177230_c().getExplosionResistance(state, (IBlockReader)level, iterPos, null) < (double)maxResistance - (double)maxResistance * distance / (double)f2)) continue;
            level.func_175656_a(iterPos, Blocks.field_150350_a.func_176223_P());
        }
        level.func_217398_a(explosive, explosive.func_226277_ct_(), explosive.func_226278_cu_(), explosive.func_226281_cx_(), radius * 0.38f, true, explosionsBreakBlocks ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
    }

    public static void gravity(World level, Entity explosive, @Nullable Entity owner, Vector3d pos, float radius, int duration, int amplifier) {
        level.func_217376_c((Entity)new BlackHoleEntity(level, pos, radius).setOwner(owner instanceof LivingEntity ? (LivingEntity)owner : null));
    }
}

