/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.recipe;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.tools.common.registries.ToolsRecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PaxelRecipe
extends WrappedShapedRecipe {
    public PaxelRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ToolsRecipeSerializers.PAXEL.getRecipeSerializer();
    }

    public ItemStack assemble(CraftingInventory inv) {
        if (this.func_77571_b().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = this.func_77571_b().func_77946_l();
        if (!toReturn.func_77984_f() || toReturn.func_77951_h()) {
            return toReturn;
        }
        int totalDurability = 0;
        int totalMaxDurability = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77973_b().isDamageable(stack)) continue;
            int max = stack.func_77958_k();
            totalDurability += max - stack.func_77952_i();
            totalMaxDurability += max;
        }
        if (totalDurability == totalMaxDurability) {
            return toReturn;
        }
        int maxDurability = toReturn.func_77958_k();
        int targetDurability = MathUtils.clampToInt((double)((double)maxDurability * ((double)totalDurability / (double)totalMaxDurability)));
        if (targetDurability == 0) {
            return ItemStack.field_190927_a;
        }
        if (targetDurability < maxDurability) {
            toReturn.func_196085_b(maxDurability - targetDurability);
        }
        return toReturn;
    }
}

