/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.util.pars;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.skds.wpo.WPO;

public class FluidPars {
    public final int isPassable;
    private Set<Fluid> destroyableBy = new HashSet<Fluid>();

    public FluidPars(int passable, Set<Fluid> destroyableBy) {
        this.isPassable = passable;
        if (destroyableBy != null) {
            this.destroyableBy = destroyableBy;
        }
    }

    public boolean isDestroyableBy(Fluid fluid) {
        return this.destroyableBy.contains(fluid);
    }

    public static FluidPars readFromJson(JsonElement json, String name) {
        if (json == null) {
            WPO.LOGGER.error("Invalid properties: \"" + name + "\"");
            return null;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement passableElement = jsonObject.get("isPassable");
        JsonElement dbfElement = jsonObject.get("destroyableByFluids");
        int passable = passableElement != null ? passableElement.getAsInt() : 0;
        HashSet<Fluid> dby = new HashSet<Fluid>();
        if (dbfElement != null) {
            if (!dbfElement.isJsonArray()) {
                WPO.LOGGER.error("Property \"destroyableByFluids\" in \"" + name + "\" is invalid");
                return null;
            }
            JsonArray dbfJ = dbfElement.getAsJsonArray();
            if (dbfJ.size() > 0) {
                dbfJ.forEach(jse -> {
                    String id = jse.getAsString();
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(id));
                    if (fluid != null && fluid != Fluids.field_204541_a) {
                        dby.add(fluid);
                    } else {
                        WPO.LOGGER.error("Fluid \"" + id + "\" does not exist!");
                    }
                });
            }
        }
        return new FluidPars(passable, dby);
    }
}

