/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.fluidphysics;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.skds.core.api.multithreading.ITaskRunnable;
import net.skds.wpo.fluidphysics.FFluidBasic;
import net.skds.wpo.fluidphysics.FFluidDefault;
import net.skds.wpo.fluidphysics.FFluidEQ;
import net.skds.wpo.fluidphysics.WorldWorkSet;
import net.skds.wpo.util.TaskBlocker;

public abstract class FluidTask
implements ITaskRunnable {
    private static double uuid = 0.0;
    public int worker = -1;
    public final WorldWorkSet owner;
    public final long pos;
    public final double priority;

    public FluidTask(WorldWorkSet owner, long pos) {
        this.owner = owner;
        this.pos = pos;
        uuid += 1.0E-6;
        if (uuid >= 1.0) {
            uuid = 0.0;
        }
        this.priority = owner.glob.getSqDistToNBP(BlockPos.func_218283_e((long)pos)) + uuid;
    }

    public boolean revoke(World wr) {
        ServerWorld w = this.owner.world;
        if (w != wr) {
            return false;
        }
        BlockPos pos2 = BlockPos.func_218283_e((long)this.pos);
        w.func_205219_F_().func_205360_a(pos2, (Object)w.func_204610_c(pos2).func_206886_c(), 2);
        return true;
    }

    public double getPriority() {
        return this.priority;
    }

    public int getSubPriority() {
        return 0;
    }

    public static class EQTask
    extends FluidTask {
        public EQTask(WorldWorkSet owner, long pos) {
            super(owner, pos);
        }

        public void run() {
            FFluidEQ t = new FFluidEQ(this.owner.world, BlockPos.func_218283_e((long)this.pos), this.owner, FFluidBasic.Mode.EQUALIZER, this.worker);
            t.run();
            if (this.worker != -1) {
                TaskBlocker.finish(this.worker);
            }
        }
    }

    public static class DefaultTask
    extends FluidTask {
        public DefaultTask(WorldWorkSet owner, long pos) {
            super(owner, pos);
        }

        public void run() {
            if (this.owner.excludedTasks.contains((Object)this.pos)) {
                return;
            }
            FFluidDefault t = new FFluidDefault(this.owner.world, BlockPos.func_218283_e((long)this.pos), this.owner, FFluidBasic.Mode.DEFAULT, this.worker);
            t.run();
            if (this.worker != -1) {
                TaskBlocker.finish(this.worker);
            }
        }
    }
}

