/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.fluidphysics;

import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.skds.wpo.WPOConfig;
import net.skds.wpo.fluidphysics.FFluidBasic;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.fluidphysics.WorldWorkSet;

public class FFluidEQV2
extends FFluidBasic {
    FFluidEQV2(ServerWorld w, BlockPos pos, WorldWorkSet owner, FFluidBasic.Mode mode, int worker) {
        super(w, pos, mode, owner, worker);
    }

    @Override
    public void execute() {
        if (this.getBlockState(this.pos.func_177984_a()).func_204520_s().func_206888_e() && !FFluidStatic.canOnlyFullCube(this.state) && !this.canFlow(this.pos, this.pos.func_177977_b(), this.state, this.getBlockState(this.pos.func_177977_b()), true, false)) {
            this.equalize();
        }
    }

    public void equalize() {
        boolean slide = (Integer)WPOConfig.COMMON.maxSlideDist.get() > 0;
        boolean slided = false;
        int i0 = this.w.func_201674_k().nextInt(4);
        if (slide && !this.canReach(this.pos, this.pos.func_177977_b(), this.state, this.getBlockState(this.pos.func_177977_b())) && this.level == 1) {
            slided = this.slide();
        }
        int dist = (Integer)WPOConfig.COMMON.maxEqDist.get();
        if (!slided && dist > 0) {
            for (int index = 0; index < 4 && this.level > 0; ++index) {
                if (this.cancel) {
                    return;
                }
                Direction dir = Direction.func_176731_b((int)((index + i0) % 4));
                this.equalizeLine(dir, false, dist);
            }
        }
    }

    public boolean slide() {
        int slideDist;
        int lenmin = slideDist = ((Integer)WPOConfig.COMMON.maxSlideDist.get()).intValue();
        boolean selPosb = false;
        BlockPos selPos = this.pos;
        boolean[] diag2 = new boolean[]{false, true};
        for (Direction dir : FFluidStatic.getRandomizedDirections(this.w.func_201674_k(), false)) {
            block1: for (boolean diag : diag2) {
                boolean selPosb2 = false;
                BlockPos selPos2 = this.pos;
                int dist = 0;
                int len = lenmin;
                BlockPos pos2 = this.pos;
                BlockPos pos1 = this.pos;
                boolean cont = true;
                boolean side = false;
                BlockState state1 = this.state;
                BlockState state2 = this.state;
                boolean bl = false;
                while (cont && len > 0) {
                    pos1 = pos2;
                    state1 = state2;
                    if (diag) {
                        if (side) {
                            dir = dir.func_176746_e();
                            side = !side;
                        } else {
                            dir = dir.func_176735_f();
                            side = !side;
                        }
                    }
                    pos2 = pos1.func_177972_a(dir);
                    state2 = this.getBlockState(pos2);
                    FluidState fs2 = state2.func_204520_s();
                    if (!this.canReach(pos1, pos2, state1, state2) || !fs2.func_206888_e() && (fs2.func_206882_g() >= 2 || !fs2.func_206886_c().func_207187_a(this.fluid)) || (state1.func_177230_c() instanceof IWaterLoggable || state2.func_177230_c() instanceof IWaterLoggable) && !(this.fluid instanceof WaterFluid)) continue block1;
                    if (dist > 0 && !selPosb2 && fs2.func_206888_e()) {
                        selPosb2 = true;
                        selPos2 = pos1;
                    }
                    bl = this.canFlow(pos1, pos1.func_177977_b(), state1, this.getBlockState(pos1.func_177977_b()), true, false) && !FFluidStatic.canOnlyFullCube(state2);
                    --len;
                    if (bl && !this.cancel && selPosb2) {
                        lenmin = Math.min(dist, lenmin);
                        selPos = selPos2;
                        selPosb = true;
                    }
                    ++dist;
                }
            }
        }
        return selPosb && this.flow(this.pos, selPos, -1);
    }

    public void equalizeLine(Direction dir, boolean diag, int len) {
        BlockPos pos2 = this.pos;
        BlockPos pos1 = this.pos;
        int len2 = len;
        boolean cont = true;
        boolean side = false;
        BlockState state1 = this.state;
        BlockState state2 = this.state;
        boolean bl = false;
        boolean blocked = false;
        while (cont && len > 0) {
            if (!diag && len2 - len == 1) {
                this.equalizeLine(dir, true, len);
            }
            if (diag) {
                if (side) {
                    dir = dir.func_176746_e();
                    side = !side;
                } else {
                    dir = dir.func_176735_f();
                    side = !side;
                }
            }
            pos1 = pos2;
            state1 = state2;
            BlockPos pos1u = pos1.func_177984_a();
            BlockState state1u = this.getBlockState(pos1u);
            FluidState fs1u = state1u.func_204520_s();
            if (!blocked && this.canReach(pos1u, pos1, state1u, state1) && !fs1u.func_206888_e() && this.isThisFluid(fs1u.func_206886_c())) {
                pos2 = pos1u;
                state2 = state1u;
                bl = true;
            } else {
                pos2 = pos1.func_177972_a(dir);
                state2 = this.getBlockState(pos2);
            }
            FluidState fs2 = state2.func_204520_s();
            if (this.isPassedEq(pos2)) break;
            if (this.canReach(pos1, pos2, state1, state2) && (this.isThisFluid(fs2.func_206886_c()) || fs2.func_206888_e() && this.level > 1)) {
                if ((state1.func_177230_c() instanceof IWaterLoggable || state2.func_177230_c() instanceof IWaterLoggable) && !(this.fluid instanceof WaterFluid)) break;
                bl = true;
                blocked = false;
            } else {
                pos2 = pos1.func_177977_b();
                state1 = state2;
                state2 = this.getBlockState(pos2);
                fs2 = state2.func_204520_s();
                if (!this.canReach(pos1, pos2, state1, state2) || (fs2.func_206888_e() || !this.isThisFluid(fs2.func_206886_c())) && !fs2.func_206888_e()) break;
                bl = true;
                blocked = true;
            }
            if (bl && !this.cancel) {
                int h;
                int l2;
                int level2 = fs2.func_206882_g();
                int l1 = this.getAbsoluteLevel(this.pos.func_177956_o(), this.level);
                if (Math.abs(l1 - (l2 = this.getAbsoluteLevel(pos2.func_177956_o(), level2))) > 1 && this.flow(this.pos, pos2, h = pos2.func_177956_o() - this.pos.func_177956_o())) {
                    this.addPassedEq(pos2);
                    return;
                }
            }
            --len;
        }
    }

    private boolean canFlow(BlockPos pos1, BlockPos pos2, BlockState state1, BlockState state2, boolean down, boolean ignoreLevels) {
        if (state2 == null) {
            this.cancel = true;
            return false;
        }
        if ((FFluidStatic.canOnlyFullCube(state2) || FFluidStatic.canOnlyFullCube(this.state)) && !down) {
            return false;
        }
        if (FFluidStatic.canOnlyFullCube(state2) && state1.func_204520_s().func_206882_g() < 8) {
            return false;
        }
        if ((state1.func_177230_c() instanceof IWaterLoggable || state2.func_177230_c() instanceof IWaterLoggable) && !(this.fluid instanceof WaterFluid)) {
            return false;
        }
        if (!this.canReach(pos1, pos2, state1, state2)) {
            return false;
        }
        FluidState fs2 = state2.func_204520_s();
        int level2 = fs2.func_206882_g();
        if (level2 >= 8 && !ignoreLevels) {
            return false;
        }
        if (this.level == 1 && !down && !ignoreLevels) {
            if (fs2.func_206888_e()) {
                pos1 = pos2;
                pos2 = pos2.func_177977_b();
                state1 = state2;
                state2 = this.getBlockState(pos2);
                if (this.isThisFluid(state2.func_204520_s().func_206886_c()) || state2.func_204520_s().func_206888_e()) {
                    return this.canFlow(pos1, pos2, state1, state2, true, false);
                }
                return false;
            }
            return level2 + 2 < this.level;
        }
        return true;
    }
}

