/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.fluidphysics;

import java.util.Iterator;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.skds.core.util.blockupdate.WWSGlobal;
import net.skds.wpo.fluidphysics.FFluidBasic;
import net.skds.wpo.fluidphysics.FFluidEQ;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.fluidphysics.WorldWorkSet;

public class FFluidDefault
extends FFluidBasic {
    BlockState downstate;
    BlockState[] nbs;
    int[] nbl;
    boolean[] nbc;
    boolean dcFlag = false;
    boolean dm = true;
    boolean dc = false;
    boolean sc = false;
    int lmin = 8;
    int c = 0;
    int sum = this.level;

    FFluidDefault(ServerWorld w, BlockPos pos, WorldWorkSet owner, FFluidBasic.Mode mode, int worker) {
        super(w, pos, mode, owner, worker);
        this.nbs = new BlockState[4];
        this.nbl = new int[4];
        this.nbc = new boolean[4];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        if (!this.w.func_72863_F().func_222866_a(this.pos)) {
            ServerWorld serverWorld = this.w;
            synchronized (serverWorld) {
                this.w.func_205219_F_().func_205360_a(this.pos, (Object)this.fluid, FFluidStatic.getTickRate((FlowingFluid)this.fluid, (IWorldReader)this.w));
            }
            return;
        }
        if (!this.validate(this.pos)) {
            return;
        }
        BlockPos posD = this.pos.func_177977_b();
        if (posD.func_177956_o() < 0) {
            this.level = 0;
            this.state = this.getUpdatedState(this.state, this.level);
            this.sc = true;
            this.setState(this.pos, this.state);
            return;
        }
        if (!this.validate(posD)) {
            return;
        }
        this.downstate = this.getBlockState(posD);
        if (this.downstate == null) {
            this.cancel = true;
            return;
        }
        if (this.canFlow(this.pos, posD, this.state, this.downstate, true, false)) {
            if (FFluidStatic.canOnlyFullCube(this.state) || FFluidStatic.canOnlyFullCube(this.downstate)) {
                int l = this.state.func_204520_s().func_206882_g();
                int ld = this.downstate.func_204520_s().func_206882_g();
                if (ld == 0 && l == 8) {
                    this.flowFullCube(posD, this.downstate);
                    return;
                }
            } else {
                this.flowDown(posD, this.downstate);
                this.addPassedEq(posD);
                this.setState(this.pos, this.state);
                this.setState(posD, this.downstate);
                if (!this.dm) {
                    return;
                }
            }
        }
        if (!this.dc && FFluidStatic.canOnlyFullCube(this.state)) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos pos2 = this.pos.func_177972_a(dir);
                if (!this.validate(pos2)) {
                    return;
                }
                BlockState state2 = this.getBlockState(pos2);
                if (!state2.func_204520_s().func_206888_e() || FFluidStatic.canOnlyFullCube(state2) || !this.canReach(this.pos, pos2, this.state, state2)) continue;
                this.flowFullCube(pos2, state2);
                return;
            }
        }
        Iterator dirs = Direction.Plane.HORIZONTAL.iterator();
        int i = 0;
        if (!this.dc) {
            while (dirs.hasNext() && this.level > 0) {
                BlockPos posu;
                BlockState stateu;
                Direction dir = (Direction)dirs.next();
                BlockPos pos2 = this.pos.func_177972_a(dir);
                if (!this.validate(pos2)) {
                    return;
                }
                BlockState state2 = this.getBlockState(pos2);
                if (FFluidStatic.canOnlyFullCube(state2) && this.canFlow(this.pos, pos2, this.state, state2, true, false) && !this.dc && (stateu = this.getBlockState(posu = this.pos.func_177984_a())).func_204520_s().func_206882_g() > 0 && this.canFlow(posu, this.pos, stateu, this.state, true, true)) {
                    this.reset(-1);
                    this.flowFullCube(pos2, state2);
                    return;
                }
                if (this.canFlow(this.pos, pos2, this.state, state2, false, false)) {
                    FluidState fs2 = state2.func_204520_s();
                    int level2 = fs2.func_206882_g();
                    if (level2 < this.lmin) {
                        this.reset(level2);
                    }
                    if (level2 <= this.lmin && level2 < this.level) {
                        this.nbs[i] = state2;
                        this.nbl[i] = level2;
                        this.nbc[i] = true;
                        this.sum += level2;
                        this.sc = true;
                        ++this.c;
                    }
                }
                ++i;
            }
        }
        if (this.c > 0) {
            int level2 = this.sum / (this.c + 1);
            int d = this.sum % (this.c + 1);
            this.level = level2 + d;
            this.state = this.getUpdatedState(this.state, this.level);
            int r = -1;
            if (d > 0) {
                r = this.w.func_201674_k().nextInt(this.c);
            }
            i = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos pos2 = this.pos.func_177972_a(dir);
                if (this.nbc[i]) {
                    if (r == 0 && this.canFlow(this.pos, pos2, this.state, this.nbs[i], false, false)) {
                        this.nbs[i] = this.getUpdatedState(this.nbs[i], level2);
                        this.flowTo(pos2, this.nbs[i], i);
                    } else {
                        this.nbs[i] = this.getUpdatedState(this.nbs[i], level2);
                    }
                    if (!this.cancel && this.sc) {
                        this.setState(pos2, this.nbs[i]);
                    }
                    --r;
                }
                ++i;
            }
        }
        if (this.sc && !this.cancel) {
            this.setState(this.pos, this.state);
        }
        if (this.dc && this.sc && !this.cancel) {
            this.setState(posD, this.downstate);
        }
        if (!(!this.getBlockState(this.pos.func_177984_a()).func_204520_s().func_206888_e() || FFluidStatic.canOnlyFullCube(this.state) || this.dc || this.sc || this.cancel)) {
            this.banPoses.remove(this.pos);
            WWSGlobal wwsg = this.owner.getG();
            this.banPoses.forEach(p -> wwsg.unbanPos(p.func_218275_a()));
            this.banPoses.clear();
            this.banPoses.add(this.pos);
            new FFluidEQ(this.w, this.pos, this.castOwner, FFluidBasic.Mode.EQUALIZER, this.worker).run();
        }
    }

    private void reset(int level2) {
        this.nbs = new BlockState[4];
        this.nbc = new boolean[4];
        this.nbl = new int[4];
        this.lmin = level2;
        this.sum = this.level;
        this.c = 0;
    }

    private void flowDown(BlockPos pos2, BlockState state2) {
        if (state2 == null) {
            this.cancel = true;
            return;
        }
        FluidState fs2 = state2.func_204520_s();
        int level2 = fs2.func_206882_g();
        if (!this.fluid.func_207187_a(fs2.func_206886_c())) {
            level2 = 0;
        }
        boolean bl = this.dcFlag = this.level > 1;
        if ((level2 += this.level) > 8) {
            this.dcFlag = false;
            this.level = level2 - 8;
            level2 = 8;
        } else {
            this.level = 0;
        }
        if (this.dcFlag) {
            ++this.level;
            --level2;
        }
        this.state = this.getUpdatedState(this.state, this.level);
        this.downstate = this.getUpdatedState(state2, level2);
        this.dm = level2 >= 8;
        this.sc = true;
        this.dc = true;
    }

    private void flowTo(BlockPos pos2, BlockState state2, int side) {
        if (state2 == null) {
            this.cancel = true;
            return;
        }
        FluidState fs2 = state2.func_204520_s();
        int level2 = fs2.func_206882_g();
        if (!this.fluid.func_207187_a(fs2.func_206886_c())) {
            level2 = 0;
        }
        if (this.level > level2 + 1) {
            int delta = (this.level - level2) / 2;
            this.level -= delta;
            this.state = this.getUpdatedState(this.state, this.level);
            this.nbs[side] = this.getUpdatedState(state2, level2 += delta);
            this.nbc[side] = true;
            this.sc = true;
        } else if (this.level == 1 && level2 == 0) {
            level2 = this.level;
            this.level = 0;
            this.state = this.getUpdatedState(this.state, this.level);
            this.nbs[side] = this.getUpdatedState(state2, level2);
            this.nbc[side] = true;
            this.sc = true;
        }
    }

    private boolean canFlow(BlockPos pos1, BlockPos pos2, BlockState state1, BlockState state2, boolean down, boolean ignoreLevels) {
        if (state2 == null) {
            this.cancel = true;
            return false;
        }
        if ((FFluidStatic.canOnlyFullCube(state2) || FFluidStatic.canOnlyFullCube(this.state)) && !down) {
            return false;
        }
        if (FFluidStatic.canOnlyFullCube(state2) && state1.func_204520_s().func_206882_g() < 8) {
            return false;
        }
        if (!this.canReach(pos1, pos2, state1, state2)) {
            return false;
        }
        FluidState fs2 = state2.func_204520_s();
        int level2 = fs2.func_206882_g();
        if (level2 >= 8 && !ignoreLevels && this.fluid.func_207187_a(fs2.func_206886_c())) {
            return false;
        }
        if (this.level == 1 && !down && !ignoreLevels) {
            if (fs2.func_206888_e()) {
                pos1 = pos2;
                pos2 = pos2.func_177977_b();
                state1 = state2;
                state2 = this.getBlockState(pos2);
                if (this.isThisFluid(state2.func_204520_s().func_206886_c()) || state2.func_204520_s().func_206888_e()) {
                    return this.canFlow(pos1, pos2, state1, state2, true, false);
                }
                return false;
            }
            return level2 + 2 < this.level;
        }
        return down || level2 + 1 < this.level;
    }
}

