/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.data;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IdentityPalette;
import net.minecraft.util.palette.PalettedContainer;
import net.skds.core.api.IChunkSectionData;
import net.skds.core.util.SKDSUtils;
import net.skds.core.util.data.ChunkSectionAdditionalData;
import net.skds.wpo.data.FluidStateContainer;
import net.skds.wpo.data.SerialUtils;

public class WPOChunkData
implements IChunkSectionData {
    private static final IPalette<FluidStateContainer> REGISTRY_PALETTE = new IdentityPalette(FluidStateContainer.getIdentityMap(), (Object)FluidStateContainer.WATER_DEBUG);
    private final PalettedContainer<FluidStateContainer> data;
    private final SKDSUtils.Side side;
    public final ChunkSectionAdditionalData sectionData;

    public WPOChunkData(ChunkSectionAdditionalData sectionData, SKDSUtils.Side side) {
        this.sectionData = sectionData;
        this.side = side;
        this.data = new PalettedContainer(REGISTRY_PALETTE, FluidStateContainer.getIdentityMap(), SerialUtils::readFluidStateC, SerialUtils::writeFluidStateC, (Object)FluidStateContainer.WATER_DEBUG);
    }

    public void deserialize(CompoundNBT nbt) {
        this.data.func_222642_a(nbt.func_150295_c("Fluids", 10), nbt.func_197645_o("FluidStates"));
    }

    public void serialize(CompoundNBT nbt) {
        this.data.func_196963_b(nbt, "Fluids", "FluidStates");
    }

    public FluidStateContainer setFS(int x, int y, int z, FluidStateContainer value) {
        return (FluidStateContainer)this.data.func_222639_b(x & 0xF, y & 0xF, z & 0xF, (Object)value);
    }

    public FluidStateContainer getFS(int x, int y, int z) {
        return (FluidStateContainer)this.data.func_186016_a(x & 0xF, y & 0xF, z & 0xF);
    }

    public void read(PacketBuffer buff) {
        this.data.func_186010_a(buff);
    }

    public void write(PacketBuffer buff) {
        this.data.func_186009_b(buff);
    }

    public SKDSUtils.Side getSide() {
        return this.side;
    }

    public int getSize() {
        return this.data.func_186018_a();
    }
}

