/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={WorldRenderer.class})
public class CancelEntityRenderMixin {
    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;entitiesForRendering()Ljava/lang/Iterable;"))
    @Group(name="entityFilter", min=1, max=1)
    private Iterable<Entity> filterEntities(ClientWorld world) {
        Iterable entities = world.func_217416_b();
        if (Backend.getInstance().canUseInstancing()) {
            ArrayList filtered = Lists.newArrayList((Iterable)entities);
            InstancedRenderRegistry r = InstancedRenderRegistry.getInstance();
            filtered.removeIf(r::shouldSkipRender);
            return filtered;
        }
        return entities;
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/ClassInheritanceMultiMap;iterator()Ljava/util/Iterator;"))
    @Group(name="entityFilter")
    private Iterator<Entity> filterEntitiesOF(ClassInheritanceMultiMap<Entity> classInheritanceMultiMap) {
        if (Backend.getInstance().canUseInstancing()) {
            ArrayList filtered = Lists.newArrayList(classInheritanceMultiMap);
            InstancedRenderRegistry r = InstancedRenderRegistry.getInstance();
            filtered.removeIf(r::shouldSkipRender);
            return filtered.iterator();
        }
        return classInheritanceMultiMap.iterator();
    }
}

