/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.versioned.framebuffer;

import com.jozufozu.flywheel.backend.gl.versioned.GlVersioned;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GLCapabilities;

public enum Framebuffer implements GlVersioned
{
    CORE{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.OpenGL30;
        }

        @Override
        public void bindFramebuffer(int target, int framebuffer) {
            GL30C.glBindFramebuffer((int)target, (int)framebuffer);
        }
    }
    ,
    ARB{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.GL_ARB_framebuffer_object;
        }

        @Override
        public void bindFramebuffer(int target, int framebuffer) {
            ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebuffer);
        }
    }
    ,
    EXT{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.GL_EXT_framebuffer_object;
        }

        @Override
        public void bindFramebuffer(int target, int framebuffer) {
            EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public boolean supported(GLCapabilities caps) {
            return true;
        }

        @Override
        public void bindFramebuffer(int target, int framebuffer) {
            throw new UnsupportedOperationException("Framebuffers not supported");
        }
    };


    public abstract void bindFramebuffer(int var1, int var2);
}

