/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.mixin;

import hellfirepvp.astralsorcery.common.util.collision.CollisionHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity {
    @Inject(method={"collideBoundingBoxHeuristically"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    private static void addCustomCollision(Entity entity, Vector3d vec, AxisAlignedBB collisionBox, World world, ISelectionContext context, ReuseableStream<VoxelShape> potentialHits, CallbackInfoReturnable<Vector3d> cir) {
        if (entity == null) {
            return;
        }
        Vector3d allowedMovement = CollisionHelper.onEntityCollision(vec, entity);
        if (allowedMovement != null) {
            cir.setReturnValue((Object)allowedMovement);
        }
    }
}

