/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.collision;

import hellfirepvp.astralsorcery.common.util.collision.CollisionManager;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeSpliterator;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;

public class CollisionHelper {
    public static boolean onCollision(VoxelShapeSpliterator iterator, Consumer<? super VoxelShape> action) {
        if (!CollisionManager.needsCustomCollision(iterator.field_234868_a_)) {
            return false;
        }
        AxisAlignedBB box = CollisionManager.getIteratorBoundingBoxes(iterator, iterator.field_234868_a_);
        if (box == null) {
            return false;
        }
        VoxelShape floor = VoxelShapes.func_197881_a((AxisAlignedBB)box);
        if (VoxelShapes.func_197879_c((VoxelShape)floor, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)iterator.field_234869_b_.func_186662_g(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            action.accept((VoxelShape)floor);
            return true;
        }
        return false;
    }

    @Nullable
    public static Vector3d onEntityCollision(Vector3d allowedMovement, Entity entity) {
        if (!CollisionManager.needsCustomCollision(entity)) {
            return null;
        }
        List<AxisAlignedBB> additionalBoxes = CollisionManager.getAdditionalBoundingBoxes(entity);
        AxisAlignedBB entityBox = entity.func_174813_aQ().func_186662_g(1.0E-7);
        for (AxisAlignedBB box : additionalBoxes) {
            double newYMovement = VoxelShapes.func_197881_a((AxisAlignedBB)box).func_212430_a(Direction.Axis.Y, entityBox, allowedMovement.field_72448_b);
            allowedMovement = new Vector3d(allowedMovement.field_72450_a, newYMovement, allowedMovement.field_72449_c);
        }
        return allowedMovement;
    }
}

