/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.base.TreeType;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.types.TypeTreeBeaconColor;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeaconComponent;
import hellfirepvp.astralsorcery.common.tile.base.TileAreaOfInfluence;
import hellfirepvp.astralsorcery.common.tile.base.network.TileReceiverBase;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverTreeBeacon;
import hellfirepvp.astralsorcery.common.util.CalendarUtils;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class TileTreeBeacon
extends TileReceiverBase<StarlightReceiverTreeBeacon>
implements TileAreaOfInfluence {
    private final Map<BlockPos, Integer> treeComponents = new HashMap<BlockPos, Integer>();
    private UUID playerUUID = null;
    private float starlight = 0.0f;

    public TileTreeBeacon() {
        super(TileEntityTypesAS.TREE_BEACON);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().func_201670_d()) {
            this.playEffects();
        } else {
            this.doHarvestCycle();
        }
    }

    private void doHarvestCycle() {
        boolean changed = this.starlight > 0.0f || !this.treeComponents.isEmpty();
        int cycles = Math.max(1, MathHelper.func_76123_f((float)(this.starlight * 0.8f)));
        this.starlight = 0.0f;
        for (int i = 0; i < cycles; ++i) {
            TileTreeBeaconComponent component;
            BlockPos pos;
            float filled = (float)this.treeComponents.size() / ((Integer)Config.CONFIG.maxCount.get()).floatValue();
            if (rand.nextFloat() >= filled * 0.25f || (pos = MiscUtils.getWeightedRandomEntry(this.treeComponents.keySet(), rand, this.treeComponents::get)) == null || (component = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), pos, TileTreeBeaconComponent.class, false)) == null || !this.harvestTree(component)) continue;
            int breakChance = (Integer)Config.CONFIG.breakChance.get();
            if (breakChance > 0 && rand.nextInt(breakChance) == 0 && component.removeSelf()) {
                this.treeComponents.remove(pos);
            }
            PktPlayEffect effect = new PktPlayEffect(PktPlayEffect.Type.BLOCK_HARVEST_DRAW).addData(buf -> {
                ByteBufUtils.writeVector(buf, new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5));
                ByteBufUtils.writeVector(buf, new Vector3((Vector3i)this.func_174877_v()).add(0.5, 0.5, 0.5));
                buf.writeInt(this.getColor(LogicalSide.SERVER).getRGB());
            });
            PacketChannel.CHANNEL.sendToAllAround(effect, PacketChannel.pointFromPos(this.func_145831_w(), (Vector3i)this.func_174877_v(), 32.0));
        }
        if (changed) {
            this.markForUpdate();
        }
    }

    private boolean harvestTree(TileTreeBeaconComponent harvest) {
        if ((double)rand.nextFloat() > (Double)Config.CONFIG.dropChance.get()) {
            return true;
        }
        World world = this.func_145831_w();
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        if (!MiscUtils.canEntityTickAt((IWorld)world, harvest.func_174877_v())) {
            return false;
        }
        List<ItemStack> drops = BlockUtils.getDrops((ServerWorld)world, harvest.func_174877_v(), harvest.getFakedState(), 2, rand, ItemStack.field_190927_a);
        drops.forEach(drop -> {
            if (drop.func_190926_b()) {
                return;
            }
            Vector3 offset = new Vector3(0.5, 0.5, 0.5);
            MiscUtils.applyRandomOffset(offset, rand, 2.0f);
            offset.setY(Math.abs(offset.getY()));
            Vector3 at = new Vector3((Vector3i)this.func_174877_v()).add(offset);
            ItemUtils.dropItemNaturally(world, at.getX(), at.getY(), at.getZ(), drop);
        });
        return false;
    }

    public void receiveStarlight(double amount, IWeakConstellation type) {
        float mul = 1.0f;
        if (type.equals(ConstellationsAS.aevitas)) {
            mul = 1.4f;
        }
        this.starlight = (float)((double)this.starlight + Math.sqrt(amount) * (double)mul);
    }

    private void captureTree(Supplier<List<BlockPos>> treeGenerator) {
        List<BlockPos> tree = treeGenerator.get();
        tree.stream().sorted(Comparator.comparing(pos -> pos.func_177951_i((Vector3i)this.func_174877_v()))).filter(pos -> !this.addComponent((BlockPos)pos)).forEach(pos -> this.field_145850_b.markAndNotifyBlock(pos, this.field_145850_b.func_175726_f(pos), Blocks.field_150350_a.func_176223_P(), this.field_145850_b.func_180495_p(pos), 11, 512));
    }

    private boolean addComponent(BlockPos pos) {
        if (this.treeComponents.size() >= (Integer)Config.CONFIG.maxCount.get()) {
            return false;
        }
        World world = this.func_145831_w();
        BlockState state = world.func_180495_p(pos);
        if (!state.isAir((IBlockReader)world, pos) && this.func_145831_w().func_180501_a(pos, BlocksAS.TREE_BEACON_COMPONENT.func_176223_P(), 3)) {
            TileTreeBeaconComponent tfs = MiscUtils.getTileAt((IBlockReader)world, pos, TileTreeBeaconComponent.class, true);
            if (tfs == null) {
                this.func_145831_w().func_180501_a(pos, state, 3);
                return false;
            }
            boolean isLog = state.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h);
            tfs.setFakedState(state);
            tfs.setTreeBeaconPos(this.func_174877_v());
            tfs.setOverlayColor(this.getColor(LogicalSide.SERVER));
            return this.treeComponents.put(pos, isLog ? (Integer)Config.CONFIG.logWeight.get() : (Integer)Config.CONFIG.leafWeight.get()) == null;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        Vector3 at;
        int i;
        Color color = this.getColor(LogicalSide.CLIENT);
        VFXColorFunction colorFn = VFXColorFunction.constant(color);
        float radius = ((Double)Config.CONFIG.range.get()).floatValue();
        Vector3 thisPos = new Vector3((Vector3i)this.func_174877_v()).add(0.5, 0.5, 0.5);
        int amt = MathHelper.func_76128_c((double)((double)radius * Math.PI / 8.0));
        for (i = 0; i < amt; ++i) {
            at = MiscUtils.getRandomCirclePosition(thisPos, Vector3.RotAxis.Y_AXIS, radius);
            MiscUtils.applyRandomOffset(at, rand, 0.35f);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).color(colorFn)).setGravityStrength(-0.0015f + rand.nextFloat() * -0.001f)).setScaleMultiplier(0.3f + rand.nextFloat() * 0.1f)).setMaxAge(30 + rand.nextInt(20));
        }
        i = 0;
        while ((double)i < Math.ceil((float)amt * 1.5f)) {
            Vector3 offset = new Vector3(0.5, 0.5, 0.5);
            MiscUtils.applyRandomCircularOffset(offset, rand, radius);
            offset.setY(offset.getY() * 0.75);
            Vector3 at2 = new Vector3((Vector3i)this.func_174877_v()).add(offset);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at2)).color(colorFn)).setGravityStrength(rand.nextBoolean() ? -0.0015f : 0.0f)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setMaxAge(25 + rand.nextInt(10));
            ++i;
        }
        if (rand.nextInt(20) == 0) {
            float alphaDaytime = DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
            at = new Vector3(this).add(0.5, 0.05, 0.5);
            MiscUtils.applyRandomOffset(at, rand, 0.05f);
            ((EntityComplexFX)((EntityVisualFX)((FXLightbeam)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).setOwner(this.playerUUID)).spawn(at)).setup(at.clone().addY(7.0), 1.5, 1.5).color(colorFn)).setAlphaMultiplier(0.5f + 0.5f * (alphaDaytime *= 0.8f))).setMaxAge(64);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playDrawParticles(PktPlayEffect pkt) {
        Vector3 from = ByteBufUtils.readVector(pkt.getExtraData());
        Vector3 to = ByteBufUtils.readVector(pkt.getExtraData());
        Color c = new Color(pkt.getExtraData().readInt());
        VFXColorFunction colorFn = VFXColorFunction.constant(c);
        for (int i = 0; i < 10; ++i) {
            Vector3 at = new Vector3((Vector3i)from.toBlockPos()).add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).motion(VFXMotionController.target(to::clone, 0.04f + rand.nextFloat() * 0.05f))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.05f)).color(rand.nextFloat() > 0.8f ? VFXColorFunction.WHITE : colorFn)).setMaxAge(30 + rand.nextInt(20));
        }
    }

    @Nullable
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.markForUpdate();
    }

    public Color getColor(LogicalSide side) {
        return Optional.ofNullable(this.playerUUID).flatMap(uuid -> PatreonEffectHelper.getPatreonEffects(side, this.playerUUID).stream().filter(effect -> effect instanceof TypeTreeBeaconColor).map(effect -> (TypeTreeBeaconColor)effect).findFirst()).map(TypeTreeBeaconColor::getTreeBeaconColor).orElse(CalendarUtils.isAprilFirst() ? Color.getHSBColor(rand.nextFloat(), 1.0f, 1.0f) : ConstellationsAS.aevitas.getConstellationColor());
    }

    @Override
    @Nonnull
    public StarlightReceiverTreeBeacon provideEndpoint(BlockPos at) {
        return new StarlightReceiverTreeBeacon(at);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Color getEffectColor() {
        return this.getColor(LogicalSide.CLIENT);
    }

    @Override
    @Nonnull
    public Vector3 getEffectPosition() {
        return new Vector3(this).add(0.5, 0.5, 0.5);
    }

    @Override
    public float getRadius() {
        return ((Double)Config.CONFIG.range.get()).floatValue();
    }

    @Override
    @Nonnull
    public BlockPos getEffectOriginPosition() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public RegistryKey<World> getDimension() {
        return this.func_145831_w().func_234923_W_();
    }

    @Override
    public boolean providesEffect() {
        return !this.func_145837_r();
    }

    public void func_145829_t() {
        super.func_145829_t();
        TreeWatcher.WATCHERS.computeIfAbsent(this.getDimension(), type -> new HashSet()).add(this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        TreeWatcher.WATCHERS.computeIfAbsent(this.getDimension(), type -> new HashSet()).remove(this.func_174877_v());
    }

    @Override
    public void onBreak() {
        super.onBreak();
        this.treeComponents.keySet().forEach(pos -> {
            TileTreeBeaconComponent component = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), pos, TileTreeBeaconComponent.class, true);
            if (component != null) {
                component.revert();
            }
        });
        this.treeComponents.clear();
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.treeComponents.clear();
        ListNBT componentList = compound.func_150295_c("components", 10);
        for (int i = 0; i < componentList.size(); ++i) {
            CompoundNBT tag = componentList.func_150305_b(i);
            this.treeComponents.put(NBTHelper.readBlockPosFromNBT(tag), tag.func_74762_e("weight"));
        }
        this.starlight = compound.func_74760_g("starlight");
        this.playerUUID = NBTHelper.getUUID(compound, "playerUUID", null);
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        ListNBT componentList = new ListNBT();
        MapStream.forEach(this.treeComponents, (pos, weight) -> {
            CompoundNBT tag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(pos, tag);
            tag.func_74768_a("weight", weight.intValue());
            componentList.add((Object)tag);
        });
        compound.func_218657_a("components", (INBT)componentList);
        compound.func_74776_a("starlight", this.starlight);
        if (this.playerUUID != null) {
            compound.func_186854_a("playerUUID", this.playerUUID);
        }
    }

    public static class TreeWatcher {
        private static final Map<RegistryKey<World>, Set<BlockPos>> WATCHERS = new HashMap<RegistryKey<World>, Set<BlockPos>>();

        public static void clearServerCache() {
            WATCHERS.clear();
        }

        public static void onGrow(SaplingGrowTreeEvent event) {
            BlockPos treePos;
            if (event.getWorld().func_201670_d() || !(event.getWorld() instanceof ServerWorld)) {
                return;
            }
            ServerWorld world = (ServerWorld)event.getWorld();
            TreeType type = TreeType.isTree((World)world, treePos = event.getPos());
            if (type == null) {
                return;
            }
            double rangeSq = (Double)Config.CONFIG.range.get() * (Double)Config.CONFIG.range.get();
            BlockPos closestBeacon = WATCHERS.getOrDefault(world.func_234923_W_(), Collections.emptySet()).stream().filter(pos -> pos.func_177951_i((Vector3i)treePos) < rangeSq).min(Comparator.comparing(pos -> pos.func_177951_i((Vector3i)treePos))).orElse(null);
            if (closestBeacon == null) {
                return;
            }
            TileTreeBeacon ttb = MiscUtils.getTileAt((IBlockReader)world, closestBeacon, TileTreeBeacon.class, false);
            if (ttb == null) {
                return;
            }
            event.setResult(Event.Result.DENY);
            Supplier<List<BlockPos>> generator = type.getTreeGenerator(world, treePos, event.getRand());
            ttb.captureTree(generator);
        }
    }

    public static class Config
    extends ConfigEntry {
        public static final Config CONFIG = new Config();
        private static final float defaultRange = 12.0f;
        private static final int defaultMaxCount = 450;
        private static final float defaultDropChance = 0.15f;
        private static final int defaultBreakChance = 1000;
        private static final int defaultLogWeight = 2;
        private static final int defaultLeafWeight = 1;
        public ForgeConfigSpec.DoubleValue range;
        public ForgeConfigSpec.IntValue maxCount;
        public ForgeConfigSpec.DoubleValue dropChance;
        public ForgeConfigSpec.IntValue breakChance;
        public ForgeConfigSpec.IntValue logWeight;
        public ForgeConfigSpec.IntValue leafWeight;

        private Config() {
            super("tree_beacon");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.range = cfgBuilder.comment("Set the radius of the tree beacon.").translation(this.translationKey("range")).defineInRange("range", 12.0, 3.0, 32.0);
            this.maxCount = cfgBuilder.comment("Set the maximum amount of tree-components the tree beacon may allocate.").translation(this.translationKey("maxCount")).defineInRange("maxCount", 450, 50, 1500);
            this.dropChance = cfgBuilder.comment("Set the chance per harvest-tick for drops to get created.").translation(this.translationKey("dropChance")).defineInRange("dropChance", (double)0.15f, 0.001, 1.0);
            this.breakChance = cfgBuilder.comment("Set the chance per harvest-tick for the block to get broken (1 in <configured chance>). 0 = blocks never break.").translation(this.translationKey("breakChance")).defineInRange("breakChance", 1000, 0, Integer.MAX_VALUE);
            this.logWeight = cfgBuilder.comment("Set the weight to pick a log-block to harvest instead of a leaf-block, compared to 'leafWeight'.").translation(this.translationKey("logWeight")).defineInRange("logWeight", 2, 1, 200);
            this.leafWeight = cfgBuilder.comment("Set the weight to pick a leaf-block (strictly speaking, any non-log block) to harvest instead of a log-block, compared to 'logWeight'.").translation(this.translationKey("leafWeight")).defineInRange("leafWeight", 1, 1, 200);
        }
    }
}

