/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.util.tile.NamedInventoryTile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TileTelescope
extends TileEntitySynchronized
implements NamedInventoryTile {
    private TelescopeRotation rotation = TelescopeRotation.N;

    public TileTelescope() {
        super(TileEntityTypesAS.TELESCOPE);
    }

    public TelescopeRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(TelescopeRotation rotation) {
        this.rotation = rotation;
        this.markForUpdate();
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.rotation = TelescopeRotation.values()[compound.func_74762_e("rotation")];
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("rotation", this.rotation.ordinal());
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("screen.astralsorcery.telescope");
    }

    public static enum TelescopeRotation {
        N,
        N_E,
        E,
        S_E,
        S,
        S_W,
        W,
        N_W;


        public TelescopeRotation nextClockWise() {
            return TelescopeRotation.values()[(this.ordinal() + 1) % TelescopeRotation.values().length];
        }

        public TelescopeRotation nextCounterClockWise() {
            return TelescopeRotation.values()[(this.ordinal() + 7) % TelescopeRotation.values().length];
        }
    }
}

