/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class TransmissionChunkTracker {
    public static final TransmissionChunkTracker INSTANCE = new TransmissionChunkTracker();

    private TransmissionChunkTracker() {
    }

    public void attachListeners(IEventBus eventBus) {
        eventBus.addListener(this::onChLoad);
        eventBus.addListener(this::onChUnload);
        eventBus.addListener(this::onWorldLoad);
        eventBus.addListener(this::onWorldUnload);
    }

    private void onChLoad(ChunkEvent.Load event) {
        IWorld iWorld = event.getWorld();
        if (iWorld.func_201670_d() || !(iWorld instanceof World)) {
            return;
        }
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((World)iWorld);
        if (handle != null) {
            handle.informChunkLoad(event.getChunk().func_76632_l());
        }
    }

    private void onChUnload(ChunkEvent.Unload event) {
        IWorld iWorld = event.getWorld();
        if (iWorld.func_201670_d() || !(iWorld instanceof World)) {
            return;
        }
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((World)iWorld);
        if (handle != null) {
            handle.informChunkUnload(event.getChunk().func_76632_l());
        }
    }

    private void onWorldLoad(WorldEvent.Load event) {
        IWorld iWorld = event.getWorld();
        if (iWorld.func_201670_d() || !(iWorld instanceof World)) {
            return;
        }
        StarlightUpdateHandler.getInstance().informWorldLoad((World)iWorld);
    }

    private void onWorldUnload(WorldEvent.Unload event) {
        IWorld iWorld = event.getWorld();
        if (iWorld.func_201670_d() || !(iWorld instanceof World)) {
            return;
        }
        StarlightTransmissionHandler.getInstance().informWorldUnload((World)iWorld);
    }
}

