/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.commons.lang3.tuple.Pair;

public class PerkAttributeLimiter {
    private static final LimitRange ANY = new AcceptAll();
    private static final Map<PerkAttributeType, LimitRange> LIMITS = new HashMap<PerkAttributeType, LimitRange>();

    private PerkAttributeLimiter() {
    }

    public static void attachListeners(IEventBus bus) {
        bus.addListener(EventPriority.HIGH, PerkAttributeLimiter::onModded);
        bus.addListener(EventPriority.HIGH, PerkAttributeLimiter::onVanilla);
    }

    public static void limit(PerkAttributeType type, Supplier<Double> min, Supplier<Double> max) {
        LIMITS.put(type, new LimitRange(min, max));
    }

    public static boolean hasLimit(PerkAttributeType type) {
        return LIMITS.containsKey(type);
    }

    @Nonnull
    public static Pair<Double, Double> getLimit(PerkAttributeType type) {
        return PerkAttributeLimiter.LIMITS.getOrDefault(type, PerkAttributeLimiter.ANY).asPair();
    }

    private static void onModded(AttributeEvent.PostProcessModded event) {
        if (PerkAttributeLimiter.hasLimit(event.getType())) {
            event.setValue(LIMITS.getOrDefault(event.getType(), ANY).limit(event.getValue()));
        }
    }

    private static void onVanilla(AttributeEvent.PostProcessVanilla event) {
        PerkAttributeType type = event.resolveAttributeType();
        if (type != null) {
            event.setValue(LIMITS.getOrDefault(type, ANY).limit(event.getValue()));
        }
    }

    private static class AcceptAll
    extends LimitRange {
        private AcceptAll() {
            super(() -> Double.MIN_VALUE, () -> Double.MAX_VALUE);
        }

        @Override
        protected double limit(double value) {
            return value;
        }
    }

    private static class LimitRange {
        private final Supplier<Double> min;
        private final Supplier<Double> max;

        private LimitRange(Supplier<Double> min, Supplier<Double> max) {
            this.min = min;
            this.max = max;
        }

        protected double limit(double value) {
            return MathHelper.func_151237_a((double)value, (double)this.min.get(), (double)this.max.get());
        }

        private Pair<Double, Double> asPair() {
            return Pair.of((Object)this.min.get(), (Object)this.max.get());
        }
    }
}

