/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.block;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.tile.crystal.CollectorCrystalType;
import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalProperty;
import hellfirepvp.astralsorcery.common.crystal.CrystalPropertyRegistry;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockCustom;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ItemBlockCollectorCrystal
extends ItemBlockCustom
implements CrystalAttributeItem,
ConstellationItem {
    public ItemBlockCollectorCrystal(Block block, Item.Properties itemProperties) {
        super(block, itemProperties.func_200916_a(CommonProxy.ITEM_GROUP_AS_CRYSTALS).func_200917_a(1));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            for (IWeakConstellation cst : ConstellationRegistry.getWeakConstellations()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                this.setAttunedConstellation(stack, cst);
                CrystalProperty prop = CrystalPropertyRegistry.INSTANCE.getConstellationProperty(cst);
                CrystalAttributes attr = this.getCreativeTemplateAttributes();
                if (prop != null) {
                    attr = attr.modifyLevel(prop, prop.getMaxTier());
                }
                attr.store(stack);
                stacks.add((Object)stack);
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IWeakConstellation cst = this.getAttunedConstellation(stack);
        if (cst != null) {
            return new TranslationTextComponent(super.func_77667_c(stack) + ".typed", new Object[]{cst.getConstellationName()});
        }
        return super.func_200295_i(stack);
    }

    public abstract CollectorCrystalType getCollectorType();

    protected abstract CrystalAttributes getCreativeTemplateAttributes();

    @Override
    @Nullable
    public IWeakConstellation getAttunedConstellation(ItemStack stack) {
        return (IWeakConstellation)IConstellation.readFromNBT(NBTHelper.getPersistentData(stack), "constellation");
    }

    @Override
    public boolean setAttunedConstellation(ItemStack stack, @Nullable IWeakConstellation cst) {
        if (cst != null) {
            cst.writeToNBT(NBTHelper.getPersistentData(stack), "constellation");
        } else {
            NBTHelper.getPersistentData(stack).func_82580_o("constellation");
        }
        return true;
    }

    @Override
    @Nullable
    public IMinorConstellation getTraitConstellation(ItemStack stack) {
        return (IMinorConstellation)IConstellation.readFromNBT(NBTHelper.getPersistentData(stack), "trait");
    }

    @Override
    public boolean setTraitConstellation(ItemStack stack, @Nullable IMinorConstellation cst) {
        if (cst != null) {
            cst.writeToNBT(NBTHelper.getPersistentData(stack), "trait");
        } else {
            NBTHelper.getPersistentData(stack).func_82580_o("trait");
        }
        return true;
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes(ItemStack stack) {
        return CrystalAttributes.getCrystalAttributes(stack);
    }

    @Override
    public void setAttributes(ItemStack stack, @Nullable CrystalAttributes attributes) {
        if (attributes != null) {
            attributes.store(stack);
        } else {
            CrystalAttributes.storeNull(stack);
        }
    }
}

