/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.dynamic;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.registry.AmuletEnchantmentRegistry;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantmentHelper;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentType;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.util.object.ObjectReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.QuickChargeEnchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DynamicEnchantmentHelper {
    private static int getNewEnchantmentLevel(int current, String enchStr, ItemStack item, @Nullable List<DynamicEnchantment> context) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchStr));
        if (enchantment != null) {
            current = DynamicEnchantmentHelper.getNewEnchantmentLevel(current, enchantment, item, context);
            if (enchantment instanceof QuickChargeEnchantment) {
                current = MathHelper.func_76125_a((int)current, (int)0, (int)5);
            }
        }
        return current;
    }

    public static int getNewEnchantmentLevel(int current, Enchantment enchantment, ItemStack item, @Nullable List<DynamicEnchantment> context) {
        if (!DynamicEnchantmentHelper.canHaveDynamicEnchantment(item)) {
            return current;
        }
        if (enchantment == null || !AmuletEnchantmentRegistry.canBeInfluenced(enchantment)) {
            return current;
        }
        List<DynamicEnchantment> modifiers = context != null ? context : DynamicEnchantmentHelper.fireEnchantmentGatheringEvent(item);
        for (DynamicEnchantment mod : modifiers) {
            Enchantment target = mod.getEnchantment();
            switch (mod.getType()) {
                case ADD_TO_SPECIFIC: {
                    if (!enchantment.equals(target)) break;
                    current += mod.getLevelAddition();
                    break;
                }
                case ADD_TO_EXISTING_SPECIFIC: {
                    if (!enchantment.equals(target) || current <= 0) break;
                    current += mod.getLevelAddition();
                    break;
                }
                case ADD_TO_EXISTING_ALL: {
                    if (current <= 0) break;
                    current += mod.getLevelAddition();
                    break;
                }
            }
        }
        if (enchantment instanceof QuickChargeEnchantment) {
            current = MathHelper.func_76125_a((int)current, (int)0, (int)5);
        }
        return current;
    }

    public static ListNBT modifyEnchantmentTags(ListNBT existingEnchantments, ItemStack stack) {
        if (!DynamicEnchantmentHelper.canHaveDynamicEnchantment(stack)) {
            return existingEnchantments;
        }
        List<DynamicEnchantment> context = DynamicEnchantmentHelper.fireEnchantmentGatheringEvent(stack);
        if (context.isEmpty()) {
            return existingEnchantments;
        }
        ListNBT returnNew = new ListNBT();
        HashSet<String> enchantments = new HashSet<String>(existingEnchantments.size());
        for (int i = 0; i < existingEnchantments.size(); ++i) {
            CompoundNBT cmp = existingEnchantments.func_150305_b(i);
            String enchKey = cmp.func_74779_i("id");
            int lvl = cmp.func_74762_e("lvl");
            int newLvl = DynamicEnchantmentHelper.getNewEnchantmentLevel(lvl, enchKey, stack, context);
            CompoundNBT newEnchTag = new CompoundNBT();
            newEnchTag.func_74778_a("id", enchKey);
            newEnchTag.func_74768_a("lvl", newLvl);
            returnNew.add((Object)newEnchTag);
            enchantments.add(enchKey);
        }
        for (DynamicEnchantment mod : context) {
            String enchName;
            Enchantment ench;
            if (mod.getType() != DynamicEnchantmentType.ADD_TO_SPECIFIC || (ench = mod.getEnchantment()) == null || !AmuletEnchantmentRegistry.canBeInfluenced(ench) || !stack.canApplyAtEnchantingTable(ench) || enchantments.contains(enchName = ench.getRegistryName().toString())) continue;
            CompoundNBT newEnchTag = new CompoundNBT();
            newEnchTag.func_74778_a("id", enchName);
            newEnchTag.func_74768_a("lvl", DynamicEnchantmentHelper.getNewEnchantmentLevel(0, ench, stack, context));
            returnNew.add((Object)newEnchTag);
        }
        return returnNew;
    }

    public static Map<Enchantment, Integer> addNewLevels(Map<Enchantment, Integer> enchantmentLevelMap, ItemStack stack) {
        if (!DynamicEnchantmentHelper.canHaveDynamicEnchantment(stack)) {
            return enchantmentLevelMap;
        }
        List<DynamicEnchantment> context = DynamicEnchantmentHelper.fireEnchantmentGatheringEvent(stack);
        if (context.isEmpty()) {
            return enchantmentLevelMap;
        }
        LinkedHashMap copyRet = Maps.newLinkedHashMap(enchantmentLevelMap);
        enchantmentLevelMap.clear();
        for (Map.Entry enchant : copyRet.entrySet()) {
            enchantmentLevelMap.put((Enchantment)enchant.getKey(), DynamicEnchantmentHelper.getNewEnchantmentLevel((int)((Integer)enchant.getValue()), (Enchantment)enchant.getKey(), stack, context));
        }
        for (DynamicEnchantment mod : context) {
            Enchantment ench;
            if (mod.getType() != DynamicEnchantmentType.ADD_TO_SPECIFIC || (ench = mod.getEnchantment()) == null || !AmuletEnchantmentRegistry.canBeInfluenced(ench) || enchantmentLevelMap.containsKey(ench)) continue;
            enchantmentLevelMap.put(ench, DynamicEnchantmentHelper.getNewEnchantmentLevel(0, ench, stack, context));
        }
        return enchantmentLevelMap;
    }

    public static boolean canHaveDynamicEnchantment(ItemStack stack) {
        if (!EventFlags.CAN_HAVE_DYN_ENCHANTMENTS.isSet()) {
            ObjectReference<Boolean> mayHaveDynamicEnchantments = new ObjectReference<Boolean>(false);
            EventFlags.CAN_HAVE_DYN_ENCHANTMENTS.executeWithFlag(() -> {
                if (stack.func_190926_b()) {
                    return;
                }
                Item i = stack.func_77973_b();
                if (i.getRegistryName() == null) {
                    return;
                }
                try {
                    if (!i.func_77616_k(stack) || i instanceof BookItem) {
                        return;
                    }
                }
                catch (NullPointerException exc) {
                    return;
                }
                if (Mods.DRACONIC_EVOLUTION.owns((IForgeRegistryEntry<?>)stack.func_77973_b())) {
                    return;
                }
                mayHaveDynamicEnchantments.set(true);
            });
            return mayHaveDynamicEnchantments.get();
        }
        return false;
    }

    private static List<DynamicEnchantment> fireEnchantmentGatheringEvent(ItemStack tool) {
        PlayerEntity foundEntity = AmuletEnchantmentHelper.getPlayerHavingTool(tool);
        if (foundEntity == null) {
            return new ArrayList<DynamicEnchantment>();
        }
        DynamicEnchantmentEvent.Add addEvent = new DynamicEnchantmentEvent.Add(tool, foundEntity);
        if (MinecraftForge.EVENT_BUS.post((Event)addEvent)) {
            return new ArrayList<DynamicEnchantment>();
        }
        DynamicEnchantmentEvent.Modify modifyEvent = new DynamicEnchantmentEvent.Modify(tool, addEvent.getEnchantmentsToApply(), foundEntity);
        if (MinecraftForge.EVENT_BUS.post((Event)modifyEvent)) {
            return new ArrayList<DynamicEnchantment>();
        }
        return modifyEvent.getEnchantmentsToApply();
    }
}

