/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.attunement;

import hellfirepvp.astralsorcery.common.crafting.nojson.CustomRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public abstract class AttunementRecipe<T extends Active<?>>
extends CustomRecipe {
    public AttunementRecipe(ResourceLocation key) {
        super(key);
    }

    public abstract boolean canStartCrafting(TileAttunementAltar var1);

    @Nonnull
    public abstract T createRecipe(TileAttunementAltar var1);

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public T deserialize(TileAttunementAltar altar, CompoundNBT nbt, @Nullable T previousInstance) {
        T activeRecipe = this.createRecipe(altar);
        ((Active)activeRecipe).readFromNBT(nbt);
        return activeRecipe;
    }

    public static abstract class Active<T extends AttunementRecipe<? extends Active<T>>> {
        protected final Random rand = new Random();
        private T recipe;
        private int tick = 0;

        public Active(T recipe) {
            this.recipe = recipe;
        }

        public final T getRecipe() {
            return this.recipe;
        }

        protected int getTick() {
            return this.tick;
        }

        public final void tick(LogicalSide side, TileAttunementAltar altar) {
            this.doTick(side, altar);
            ++this.tick;
        }

        public abstract void stopCrafting(TileAttunementAltar var1);

        public abstract void startCrafting(TileAttunementAltar var1);

        public abstract void finishRecipe(TileAttunementAltar var1);

        public abstract void doTick(LogicalSide var1, TileAttunementAltar var2);

        public abstract boolean isFinished(TileAttunementAltar var1);

        @OnlyIn(value=Dist.CLIENT)
        public abstract void stopEffects(TileAttunementAltar var1);

        public boolean matches(TileAttunementAltar altar) {
            return ((AttunementRecipe)this.recipe).canStartCrafting(altar);
        }

        public void writeToNBT(CompoundNBT nbt) {
            nbt.func_74768_a("tick", this.tick);
        }

        protected void readFromNBT(CompoundNBT nbt) {
            this.tick = nbt.func_74762_e("tick");
        }
    }
}

