/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Server {
    public static long ticks;

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ticks;
        }
    }

    public static <T extends WorldSavedData> T getData(Supplier<T> supplier) {
        return Server.getData(supplier, (RegistryKey<World>)World.field_234918_g_);
    }

    public static <T extends WorldSavedData> T getData(Supplier<T> supplier, @Nullable RegistryKey<World> dim) {
        Optional<ServerWorld> world = Server.getWorld(dim);
        WorldSavedData[] data = new WorldSavedData[]{(WorldSavedData)supplier.get()};
        world.ifPresent(serverWorld -> {
            DimensionSavedDataManager dataManager = serverWorld.func_217481_x();
            data[0] = dataManager.func_215753_b(supplier, ((WorldSavedData)supplier.get()).func_195925_e());
            if (data[0] == null) {
                data[0] = (WorldSavedData)supplier.get();
                data[0].func_76185_a();
                dataManager.func_215757_a(data[0]);
            }
        });
        return (T)data[0];
    }

    public static Optional<ServerWorld> getWorld(ResourceLocation dimName) {
        return Server.getWorld((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimName));
    }

    public static Optional<ServerWorld> getWorld(@Nullable RegistryKey<World> dim) {
        return dim == null ? Optional.empty() : Optional.ofNullable(Server.get().func_71218_a(dim));
    }

    public static boolean hasPlayers() {
        return !Server.get().func_184103_al().func_181057_v().isEmpty();
    }

    public static boolean isSinglePlayer() {
        return !Server.isMultiPlayer();
    }

    public static boolean isMultiPlayer() {
        return Server.get().func_71262_S();
    }

    public static MinecraftServer get() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }
}

