/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.util.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SimpleCapabilityProvider<T>
implements INBTSerializable<CompoundNBT>,
ICapabilityProvider {
    private Capability<T> capability;
    private T instance;

    public SimpleCapabilityProvider(Capability capability, T instance) {
        this.capability = capability;
        this.instance = instance;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == this.capability ? LazyOptional.of(() -> this.instance).cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.capability.getStorage().writeNBT(this.capability, this.instance, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.capability.getStorage().readNBT(this.capability, this.instance, null, (INBT)nbt);
    }
}

