/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui.sync;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GenericContainerData<T> {
    private final GenericDataSerializers.DataSerializer<T> serializer;
    private final Supplier<T> get;
    private final Consumer<T> set;
    private T current;

    public GenericContainerData(GenericDataSerializers.DataSerializer<T> serializer, Supplier<T> get, Consumer<T> set) {
        this.serializer = serializer;
        this.get = get;
        this.set = set;
    }

    public static GenericContainerData<Integer> int32(Supplier<Integer> get, Consumer<Integer> set) {
        return new GenericContainerData<Integer>(GenericDataSerializers.INT32, get, set);
    }

    public static GenericContainerData<?> energy(FluxStorage storage) {
        return GenericContainerData.int32(storage::getEnergyStored, storage::setEnergy);
    }

    public boolean needsUpdate() {
        T newValue = this.get.get();
        if (Objects.equals(this.current, newValue)) {
            return false;
        }
        this.current = newValue;
        return true;
    }

    public void processSync(Object receivedData) {
        this.current = receivedData;
        this.set.accept(this.current);
    }

    public GenericDataSerializers.DataPair<T> dataPair() {
        return new GenericDataSerializers.DataPair<T>(this.serializer, this.current);
    }
}

