/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CraftingTableTileEntity
extends IEBaseTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IInteractionObjectIE {
    public static final int GRID_SIZE = 3;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> craftingInv = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private LazyOptional<IItemHandler> inventoryCap = this.registerConstantCap(new ItemStackHandler(this.inventory){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CraftingTableTileEntity.this.func_70296_d();
        }
    });

    public CraftingTableTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.CRAFTING_TABLE.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (!descPacket) {
            int i;
            NonNullList totalInv = NonNullList.func_191197_a((int)(this.inventory.size() + this.craftingInv.size()), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)totalInv);
            for (i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, (Object)((ItemStack)totalInv.get(i)));
            }
            for (i = 0; i < this.craftingInv.size(); ++i) {
                this.craftingInv.set(i, (Object)((ItemStack)totalInv.get(this.inventory.size() + i)));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (!descPacket) {
            int i;
            NonNullList totalInv = NonNullList.func_191197_a((int)(this.inventory.size() + this.craftingInv.size()), (Object)ItemStack.field_190927_a);
            for (i = 0; i < this.inventory.size(); ++i) {
                totalInv.set(i, (Object)((ItemStack)this.inventory.get(i)));
            }
            for (i = 0; i < this.craftingInv.size(); ++i) {
                totalInv.set(this.inventory.size() + i, (Object)((ItemStack)this.craftingInv.get(i)));
            }
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, (NonNullList)totalInv);
        }
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.immersiveengineering.craftingtable");
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    @Nonnull
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return IEBlockInterfaces.IInteractionObjectIE.super.createMenu(id, playerInventory, player);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    public NonNullList<ItemStack> getCraftingInventory() {
        return this.craftingInv;
    }
}

