/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;

public class TileEntityRenderHelper {
    public static void renderTileEntities(World world, Iterable<TileEntity> customRenderTEs, MatrixStack ms, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, null, buffer);
    }

    public static void renderTileEntities(World world, Iterable<TileEntity> customRenderTEs, MatrixStack ms, IRenderTypeBuffer buffer, float pt) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, null, buffer, pt);
    }

    public static void renderTileEntities(World world, @Nullable PlacementSimulationWorld renderWorld, Iterable<TileEntity> customRenderTEs, MatrixStack ms, @Nullable Matrix4f lightTransform, IRenderTypeBuffer buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, customRenderTEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderTileEntities(World world, @Nullable PlacementSimulationWorld renderWorld, Iterable<TileEntity> customRenderTEs, MatrixStack ms, @Nullable Matrix4f lightTransform, IRenderTypeBuffer buffer, float pt) {
        Iterator<TileEntity> iterator = customRenderTEs.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            if (Backend.getInstance().canUseInstancing((World)renderWorld) && InstancedRenderRegistry.getInstance().shouldSkipRender(tileEntity)) continue;
            TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            BlockPos pos = tileEntity.func_174877_v();
            ms.func_227860_a_();
            MatrixTransformStack.of((MatrixStack)ms).translate((Vector3i)pos);
            try {
                BlockPos lightPos;
                if (lightTransform != null) {
                    Vector4f lightVec = new Vector4f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 1.0f);
                    lightVec.func_229372_a_(lightTransform);
                    lightPos = new BlockPos((double)lightVec.func_195910_a(), (double)lightVec.func_195913_b(), (double)lightVec.func_195914_c());
                } else {
                    lightPos = pos;
                }
                int worldLight = TileEntityRenderHelper.getCombinedLight(world, lightPos, renderWorld, pos);
                renderer.func_225616_a_(tileEntity, pt, ms, buffer, worldLight, OverlayTexture.field_229196_a_);
            }
            catch (Exception e) {
                iterator.remove();
                String message = "TileEntity " + tileEntity.func_200662_C().getRegistryName().toString() + " didn't want to render while moved.\n";
                if (((Boolean)AllConfigs.CLIENT.explainRenderErrors.get()).booleanValue()) {
                    Create.LOGGER.error(message, (Throwable)e);
                }
                Create.LOGGER.error(message);
            }
            ms.func_227865_b_();
        }
    }

    public static int getCombinedLight(World world, BlockPos worldPos, @Nullable PlacementSimulationWorld renderWorld, BlockPos renderWorldPos) {
        int worldLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)worldPos);
        if (renderWorld != null) {
            int renderWorldLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)renderWorld, (BlockPos)renderWorldPos);
            return SuperByteBuffer.maxLight(worldLight, renderWorldLight);
        }
        return worldLight;
    }
}

