/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.placement.util.PoleHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GantryShaftBlock
extends DirectionalKineticBlock {
    public static final Property<Part> PART = EnumProperty.func_177709_a((String)"part", Part.class);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new Property[]{PART, POWERED}));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        ItemStack heldItem = player.func_184586_b(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!placementHelper.matchesItem(heldItem)) {
            return ActionResultType.PASS;
        }
        return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.func_77973_b(), player, hand, ray);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.EIGHT_VOXEL_POLE.get(((Direction)state.func_177229_b((Property)FACING)).func_176740_k());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbour, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        Direction.Axis axis = facing.func_176740_k();
        if (direction.func_176740_k() != axis) {
            return state;
        }
        boolean connect = AllBlocks.GANTRY_SHAFT.has(neighbour) && neighbour.func_177229_b((Property)FACING) == facing;
        Part part = (Part)((Object)state.func_177229_b(PART));
        if (direction.func_176743_c() == facing.func_176743_c()) {
            if (connect) {
                if (part == Part.END) {
                    part = Part.MIDDLE;
                }
                if (part == Part.SINGLE) {
                    part = Part.START;
                }
            } else {
                if (part == Part.MIDDLE) {
                    part = Part.END;
                }
                if (part == Part.START) {
                    part = Part.SINGLE;
                }
            }
        } else if (connect) {
            if (part == Part.START) {
                part = Part.MIDDLE;
            }
            if (part == Part.SINGLE) {
                part = Part.END;
            }
        } else {
            if (part == Part.MIDDLE) {
                part = Part.START;
            }
            if (part == Part.END) {
                part = Part.SINGLE;
            }
        }
        return (BlockState)state.func_206870_a(PART, (Comparable)((Object)part));
    }

    public GantryShaftBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)Part.SINGLE)));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState clickedState;
        BlockState state = super.func_196258_a(context);
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Direction face = context.func_196000_l();
        BlockState neighbour = world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()));
        BlockState blockState = clickedState = AllBlocks.GANTRY_SHAFT.has(neighbour) ? neighbour : world.func_180495_p(pos.func_177972_a(face.func_176734_d()));
        if (AllBlocks.GANTRY_SHAFT.has(clickedState) && ((Direction)clickedState.func_177229_b((Property)FACING)).func_176740_k() == ((Direction)state.func_177229_b((Property)FACING)).func_176740_k()) {
            Direction facing = (Direction)clickedState.func_177229_b((Property)FACING);
            state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)(context.func_195999_j() == null || !context.func_195999_j().func_225608_bj_() ? facing : facing.func_176734_d()));
        }
        return (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(this.shouldBePowered(state, world, pos)));
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        ActionResultType onWrenched = super.onWrenched(state, context);
        if (onWrenched.func_226246_a_()) {
            BlockPos pos = context.func_195995_a();
            World world = context.func_195991_k();
            this.func_220069_a(world.func_180495_p(pos), world, pos, state.func_177230_c(), pos, false);
        }
        return onWrenched;
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.func_201670_d() && oldState.func_177230_c().func_235332_a_((Block)AllBlocks.GANTRY_SHAFT.get())) {
            TileEntity te;
            Part oldPart = (Part)((Object)oldState.func_177229_b(PART));
            Part part = (Part)((Object)state.func_177229_b(PART));
            if ((oldPart != Part.MIDDLE && part == Part.MIDDLE || oldPart == Part.SINGLE && part != Part.SINGLE) && (te = worldIn.func_175625_s(pos)) instanceof GantryShaftTileEntity) {
                ((GantryShaftTileEntity)te).checkAttachedCarriageBlocks();
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((Property)POWERED);
        boolean shouldPower = worldIn.func_175640_z(pos);
        if (!previouslyPowered && !shouldPower && this.shouldBePowered(state, worldIn, pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (previouslyPowered == shouldPower) {
            return;
        }
        ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        Direction.Axis axis = facing.func_176740_k();
        block0: for (Direction d : Iterate.directionsInAxis(axis)) {
            BlockState currentState;
            BlockPos currentPos = pos.func_177972_a(d);
            while (worldIn.func_195588_v(currentPos) && (currentState = worldIn.func_180495_p(currentPos)).func_177230_c() instanceof GantryShaftBlock && currentState.func_177229_b((Property)FACING) == facing) {
                if (!shouldPower && ((Boolean)currentState.func_177229_b((Property)POWERED)).booleanValue() && worldIn.func_175640_z(currentPos)) {
                    return;
                }
                if ((Boolean)currentState.func_177229_b((Property)POWERED) == shouldPower) continue block0;
                toUpdate.add(currentPos);
                currentPos = currentPos.func_177972_a(d);
            }
        }
        toUpdate.add(pos);
        for (BlockPos blockPos : toUpdate) {
            BlockState blockState = worldIn.func_180495_p(blockPos);
            TileEntity te = worldIn.func_175625_s(blockPos);
            if (te instanceof KineticTileEntity) {
                ((KineticTileEntity)te).detachKinetics();
            }
            if (!(blockState.func_177230_c() instanceof GantryShaftBlock)) continue;
            worldIn.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(shouldPower)), 2);
        }
    }

    protected boolean shouldBePowered(BlockState state, World worldIn, BlockPos pos) {
        boolean shouldPower = worldIn.func_175640_z(pos);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        for (Direction d : Iterate.directionsInAxis(facing.func_176740_k())) {
            BlockState neighbourState;
            BlockPos neighbourPos = pos.func_177972_a(d);
            if (!worldIn.func_195588_v(neighbourPos) || !((neighbourState = worldIn.func_180495_p(neighbourPos)).func_177230_c() instanceof GantryShaftBlock) || neighbourState.func_177229_b((Property)FACING) != facing) continue;
            shouldPower |= ((Boolean)neighbourState.func_177229_b((Property)POWERED)).booleanValue();
        }
        return shouldPower;
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return face.func_176740_k() == ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.GANTRY_SHAFT.create();
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.func_177229_b((Property)POWERED) == newState.func_177229_b((Property)POWERED);
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.25f;
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }

    public static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(AllBlocks.GANTRY_SHAFT::has, s -> ((Direction)s.func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176740_k(), DirectionalKineticBlock.FACING);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return AllBlocks.GANTRY_SHAFT::isIn;
        }

        @Override
        public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            offset.withTransform(offset.getTransform().andThen(s -> (BlockState)s.func_206870_a((Property)POWERED, state.func_177229_b((Property)POWERED))));
            return offset;
        }
    }

    public static enum Part implements IStringSerializable
    {
        START,
        MIDDLE,
        END,
        SINGLE;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

