/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.jozufozu.flywheel.backend.IFlywheelWorld;
import com.jozufozu.flywheel.light.GridAlignedBB;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.actors.SeatBlock;
import com.simibubi.create.content.contraptions.components.actors.SeatEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionWorld;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedFluidStorage;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedStorage;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.WindmillBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonHeadBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.render.EmptyLighter;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateBlock;
import com.simibubi.create.content.logistics.block.inventories.CreativeCrateTileEntity;
import com.simibubi.create.content.logistics.block.redstone.RedstoneContactBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.ICoordinate;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.NBTProcessors;
import com.simibubi.create.foundation.utility.UniqueLinkedList;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Contraption {
    public Optional<List<AxisAlignedBB>> simplifiedEntityColliders;
    public AbstractContraptionEntity entity;
    public ContraptionInvWrapper inventory;
    public CombinedTankWrapper fluidInventory;
    public AxisAlignedBB bounds;
    public BlockPos anchor;
    public boolean stalled;
    public boolean hasUniversalCreativeCrate;
    protected Map<BlockPos, Template.BlockInfo> blocks = new HashMap<BlockPos, Template.BlockInfo>();
    protected Map<BlockPos, MountedStorage> storage = new HashMap<BlockPos, MountedStorage>();
    protected Map<BlockPos, MountedFluidStorage> fluidStorage;
    protected List<MutablePair<Template.BlockInfo, MovementContext>> actors;
    protected Map<BlockPos, MovingInteractionBehaviour> interactors;
    protected Set<Pair<BlockPos, Direction>> superglue;
    protected List<BlockPos> seats = new ArrayList<BlockPos>();
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    private List<SuperGlueEntity> glueToRemove;
    private Map<BlockPos, Entity> initialPassengers;
    private List<BlockFace> pendingSubContraptions;
    private CompletableFuture<Void> simplifiedEntityColliderProvider;
    public Map<BlockPos, TileEntity> presentTileEntities;
    public List<TileEntity> maybeInstancedTileEntities;
    public List<TileEntity> specialRenderedTileEntities;
    protected ContraptionWorld world;

    public Contraption() {
        this.actors = new ArrayList<MutablePair<Template.BlockInfo, MovementContext>>();
        this.interactors = new HashMap<BlockPos, MovingInteractionBehaviour>();
        this.superglue = new HashSet<Pair<BlockPos, Direction>>();
        this.seatMapping = new HashMap<UUID, Integer>();
        this.fluidStorage = new HashMap<BlockPos, MountedFluidStorage>();
        this.glueToRemove = new ArrayList<SuperGlueEntity>();
        this.initialPassengers = new HashMap<BlockPos, Entity>();
        this.presentTileEntities = new HashMap<BlockPos, TileEntity>();
        this.maybeInstancedTileEntities = new ArrayList<TileEntity>();
        this.specialRenderedTileEntities = new ArrayList<TileEntity>();
        this.pendingSubContraptions = new ArrayList<BlockFace>();
        this.stabilizedSubContraptions = new HashMap<UUID, BlockFace>();
        this.simplifiedEntityColliders = Optional.empty();
    }

    public ContraptionWorld getContraptionWorld() {
        if (this.world == null) {
            this.world = new ContraptionWorld(this.entity.field_70170_p, this);
        }
        return this.world;
    }

    public abstract boolean assemble(World var1, BlockPos var2) throws AssemblyException;

    public abstract boolean canBeStabilized(Direction var1, BlockPos var2);

    protected abstract ContraptionType getType();

    protected boolean customBlockPlacement(IWorld world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean customBlockRemoval(IWorld world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) throws AssemblyException {
        return true;
    }

    public static Contraption fromNBT(World world, CompoundNBT nbt, boolean spawnData) {
        String type = nbt.func_74779_i("Type");
        Contraption contraption = ContraptionType.fromType(type);
        contraption.readNBT(world, nbt, spawnData);
        contraption.world = new ContraptionWorld(world, contraption);
        contraption.gatherBBsOffThread();
        return contraption;
    }

    public boolean searchMovedStructure(World world, BlockPos pos, @Nullable Direction forcedDirection) throws AssemblyException {
        this.initialPassengers.clear();
        UniqueLinkedList<BlockPos> frontier = new UniqueLinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new AxisAlignedBB(BlockPos.field_177992_a);
        }
        if (!BlockMovementChecks.isBrittle(world.func_180495_p(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, forcedDirection, frontier, visited)) continue;
            return false;
        }
        throw AssemblyException.structureTooLarge();
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;
        for (BlockFace blockFace : this.pendingSubContraptions) {
            Direction face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            World world = entity.field_70170_p;
            BlockPos pos = blockFace.getPos();
            try {
                if (!subContraption.assemble(world, pos)) {
                }
            }
            catch (AssemblyException e) {}
            continue;
            subContraption.removeBlocksFromWorld(world, BlockPos.field_177992_a);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, face);
            BlockPos anchor = blockFace.getConnectedPos();
            movedContraption.func_70107_b((float)anchor.func_177958_n() + 0.5f, anchor.func_177956_o(), (float)anchor.func_177952_p() + 0.5f);
            world.func_217376_c((Entity)movedContraption);
            this.stabilizedSubContraptions.put(movedContraption.func_110124_au(), new BlockFace(this.toLocalPos(pos), face));
        }
        List list = this.storage.values().stream().map(MountedStorage::getItemHandler).collect(Collectors.toList());
        this.inventory = new ContraptionInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
        List fluidHandlers = this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).collect(Collectors.toList());
        this.fluidInventory = new CombinedTankWrapper((IFluidHandler[])Arrays.copyOf(fluidHandlers.toArray(), fluidHandlers.size(), IFluidHandler[].class));
        this.gatherBBsOffThread();
    }

    public void onEntityRemoved(AbstractContraptionEntity entity) {
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
            this.simplifiedEntityColliderProvider = null;
        }
    }

    public void onEntityInitialize(World world, AbstractContraptionEntity contraptionEntity) {
        if (world.field_72995_K) {
            return;
        }
        for (OrientedContraptionEntity orientedCE : world.func_217357_a(OrientedContraptionEntity.class, contraptionEntity.func_174813_aQ().func_186662_g(1.0))) {
            if (!this.stabilizedSubContraptions.containsKey(orientedCE.func_110124_au())) continue;
            orientedCE.func_184220_m(contraptionEntity);
        }
        for (BlockPos seatPos : this.getSeats()) {
            int seatIndex;
            Entity passenger = this.initialPassengers.get(seatPos);
            if (passenger == null || (seatIndex = this.getSeats().indexOf(seatPos)) == -1) continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    public void onEntityTick(World world) {
        this.fluidStorage.forEach((pos, mfs) -> mfs.tick(this.entity, (BlockPos)pos, world.field_72995_K));
    }

    protected boolean moveBlock(World world, @Nullable Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        Direction offset;
        BlockPos attached;
        BlockPos pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (World.func_189509_E((BlockPos)pos)) {
            return true;
        }
        if (!world.func_195588_v(pos)) {
            throw AssemblyException.unloadedChunk(pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        BlockState state = world.func_180495_p(pos);
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return true;
        }
        if (!this.movementAllowed(state, world, pos)) {
            throw AssemblyException.unmovableBlock(pos, state);
        }
        if (state.func_177230_c() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (AllBlocks.ADJUSTABLE_CRATE.has(state)) {
            AdjustableCrateBlock.splitCrate(world, pos);
        }
        if (AllBlocks.BELT.has(state)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (AllBlocks.GANTRY_CARRIAGE.has(state)) {
            this.moveGantryPinion(world, pos, frontier, visited, state);
        }
        if (AllBlocks.GANTRY_SHAFT.has(state)) {
            this.moveGantryShaft(world, pos, frontier, visited, state);
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.func_177229_b((Property)StickerBlock.EXTENDED)).booleanValue() && !visited.contains(attached = pos.func_177972_a(offset = (Direction)state.func_177229_b((Property)StickerBlock.field_176387_N))) && !BlockMovementChecks.isNotSupportive(world.func_180495_p(attached), offset.func_176734_d())) {
            frontier.add(attached);
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state)) {
            this.moveWindmillBearing(pos, frontier, visited, state);
        }
        if (state.func_177230_c() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.func_177230_c() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.func_177230_c() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            return false;
        }
        if (MechanicalPistonBlock.isExtensionPole(state)) {
            this.movePistonPole(world, pos, frontier, visited, state);
        }
        if (MechanicalPistonBlock.isPistonHead(state)) {
            this.movePistonHead(world, pos, frontier, visited, state);
        }
        BlockPos posDown = pos.func_177977_b();
        BlockState stateBelow = world.func_180495_p(posDown);
        if (!visited.contains(posDown) && AllBlocks.CART_ASSEMBLER.has(stateBelow)) {
            frontier.add(posDown);
        }
        Map<Direction, SuperGlueEntity> superglue = SuperGlueHandler.gatherGlue((IWorld)world, pos);
        for (Direction offset2 : Iterate.directions) {
            boolean canStick;
            BlockPos offsetPos = pos.func_177972_a(offset2);
            BlockState blockState = world.func_180495_p(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(blockState, world, offsetPos)) {
                if (offset2 != forcedDirection) continue;
                throw AssemblyException.unmovableBlock(pos, state);
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = superglue.containsKey(offset2);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards(blockState, world, offsetPos, offset2.func_176734_d());
            boolean brittle = BlockMovementChecks.isBrittle(blockState);
            boolean bl = canStick = !brittle && state.canStickTo(blockState) && blockState.canStickTo(state);
            if (canStick) {
                if (state.func_185905_o() == PushReaction.PUSH_ONLY || blockState.func_185905_o() == PushReaction.PUSH_ONLY) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(state, offset2)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(blockState, offset2.func_176734_d())) {
                    canStick = false;
                }
            }
            if (!wasVisited && (canStick || blockAttachedTowardsFace || faceHasGlue || offset2 == forcedDirection && !BlockMovementChecks.isNotSupportive(state, forcedDirection))) {
                frontier.add(offsetPos);
            }
            if (!faceHasGlue) continue;
            this.addGlue(superglue.get(offset2));
        }
        this.addBlock(pos, this.capture(world, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.SERVER.kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    protected void movePistonHead(World world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos attached;
        Direction direction = (Direction)state.func_177229_b((Property)MechanicalPistonHeadBlock.field_176387_N);
        BlockPos offset = pos.func_177972_a(direction.func_176734_d());
        if (!visited.contains(offset)) {
            Direction pistonFacing;
            BlockState blockState = world.func_180495_p(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((Direction)blockState.func_177229_b((Property)PistonExtensionPoleBlock.field_176387_N)).func_176740_k() == direction.func_176740_k()) {
                frontier.add(offset);
            }
            if (blockState.func_177230_c() instanceof MechanicalPistonBlock && (pistonFacing = (Direction)blockState.func_177229_b((Property)MechanicalPistonBlock.FACING)) == direction && blockState.func_177229_b(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
                frontier.add(offset);
            }
        }
        if (state.func_177229_b(MechanicalPistonHeadBlock.TYPE) == PistonType.STICKY && !visited.contains(attached = pos.func_177972_a(direction))) {
            frontier.add(attached);
        }
    }

    protected void movePistonPole(World world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (Direction d : Iterate.directionsInAxis(((Direction)state.func_177229_b((Property)PistonExtensionPoleBlock.field_176387_N)).func_176740_k())) {
            Direction pistonFacing;
            BlockPos offset = pos.func_177972_a(d);
            if (visited.contains(offset)) continue;
            BlockState blockState = world.func_180495_p(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((Direction)blockState.func_177229_b((Property)PistonExtensionPoleBlock.field_176387_N)).func_176740_k() == d.func_176740_k()) {
                frontier.add(offset);
            }
            if (MechanicalPistonBlock.isPistonHead(blockState) && ((Direction)blockState.func_177229_b((Property)MechanicalPistonHeadBlock.field_176387_N)).func_176740_k() == d.func_176740_k()) {
                frontier.add(offset);
            }
            if (!(blockState.func_177230_c() instanceof MechanicalPistonBlock) || (pistonFacing = (Direction)blockState.func_177229_b((Property)MechanicalPistonBlock.FACING)) != d && (pistonFacing != d.func_176734_d() || blockState.func_177229_b(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.EXTENDED)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryPinion(World world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos offset = pos.func_177972_a((Direction)state.func_177229_b((Property)GantryCarriageBlock.FACING));
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
        Direction.Axis rotationAxis = ((IRotate)state.func_177230_c()).getRotationAxis(state);
        for (Direction d : Iterate.directionsInAxis(rotationAxis)) {
            offset = pos.func_177972_a(d);
            BlockState offsetState = world.func_180495_p(offset);
            if (!AllBlocks.GANTRY_SHAFT.has(offsetState) || ((Direction)offsetState.func_177229_b((Property)GantryShaftBlock.FACING)).func_176740_k() != d.func_176740_k() || visited.contains(offset)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryShaft(World world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (Direction d : Iterate.directions) {
            BlockPos offset = pos.func_177972_a(d);
            if (visited.contains(offset)) continue;
            BlockState offsetState = world.func_180495_p(offset);
            Direction facing = (Direction)state.func_177229_b((Property)GantryShaftBlock.FACING);
            if (d.func_176740_k() == facing.func_176740_k() && AllBlocks.GANTRY_SHAFT.has(offsetState) && offsetState.func_177229_b((Property)GantryShaftBlock.FACING) == facing) {
                frontier.add(offset);
                continue;
            }
            if (!AllBlocks.GANTRY_CARRIAGE.has(offsetState) || offsetState.func_177229_b((Property)GantryCarriageBlock.FACING) != d) continue;
            frontier.add(offset);
        }
    }

    private void moveWindmillBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)WindmillBearingBlock.FACING);
        BlockPos offset = pos.func_177972_a(facing);
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
    }

    private void moveBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)MechanicalBearingBlock.FACING);
        if (!this.canBeStabilized(facing, pos.func_177973_b((Vector3i)this.anchor))) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!visited.contains(offset)) {
                frontier.add(offset);
            }
            return;
        }
        this.pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        BlockPos prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos)) {
            frontier.add(nextPos);
        }
        if (prevPos != null && !visited.contains(prevPos)) {
            frontier.add(prevPos);
        }
    }

    private void moveSeat(World world, BlockPos pos) {
        SeatEntity seat;
        List passengers;
        BlockPos local = this.toLocalPos(pos);
        this.getSeats().add(local);
        List seatsEntities = world.func_217357_a(SeatEntity.class, new AxisAlignedBB(pos));
        if (!seatsEntities.isEmpty() && !(passengers = (seat = (SeatEntity)((Object)seatsEntities.get(0))).func_184188_bt()).isEmpty()) {
            this.initialPassengers.put(local, (Entity)passengers.get(0));
        }
    }

    private void movePulley(World world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        int limit = (Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get();
        BlockPos ropePos = pos;
        while (limit-- >= 0 && world.func_195588_v(ropePos = ropePos.func_177977_b())) {
            BlockState ropeState = world.func_180495_p(ropePos);
            Block block = ropeState.func_177230_c();
            if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                if (visited.contains(ropePos)) break;
                frontier.add(ropePos);
                break;
            }
            this.addBlock(ropePos, this.capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(World world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) throws AssemblyException {
        BlockState poleState;
        Direction direction = (Direction)state.func_177229_b((Property)MechanicalPistonBlock.FACING);
        MechanicalPistonBlock.PistonState pistonState = (MechanicalPistonBlock.PistonState)((Object)state.func_177229_b(MechanicalPistonBlock.STATE));
        if (pistonState == MechanicalPistonBlock.PistonState.MOVING) {
            return false;
        }
        BlockPos offset = pos.func_177972_a(direction.func_176734_d());
        if (!visited.contains(offset) && AllBlocks.PISTON_EXTENSION_POLE.has(poleState = world.func_180495_p(offset)) && ((Direction)poleState.func_177229_b((Property)PistonExtensionPoleBlock.field_176387_N)).func_176740_k() == direction.func_176740_k()) {
            frontier.add(offset);
        }
        if ((pistonState == MechanicalPistonBlock.PistonState.EXTENDED || MechanicalPistonBlock.isStickyPiston(state)) && !visited.contains(offset = pos.func_177972_a(direction))) {
            frontier.add(offset);
        }
        return true;
    }

    private boolean moveChassis(World world, BlockPos pos, Direction movementDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ChassisTileEntity)) {
            return false;
        }
        ChassisTileEntity chassis = (ChassisTileEntity)te;
        chassis.addAttachedChasses(frontier, visited);
        List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (BlockPos blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<Template.BlockInfo, TileEntity> capture(World world, BlockPos pos) {
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_177230_c() instanceof ChestBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
        }
        if (AllBlocks.ADJUSTABLE_CRATE.has(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((Property)AdjustableCrateBlock.DOUBLE, (Comparable)Boolean.valueOf(false));
        }
        if (AllBlocks.REDSTONE_CONTACT.has(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((Property)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.func_177230_c() instanceof AbstractButtonBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((Property)AbstractButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(false));
            world.func_205220_G_().func_205360_a(pos, (Object)blockstate.func_177230_c(), -1);
        }
        if (blockstate.func_177230_c() instanceof PressurePlateBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false));
            world.func_205220_G_().func_205360_a(pos, (Object)blockstate.func_177230_c(), -1);
        }
        CompoundNBT compoundnbt = this.getTileEntityNBT(world, pos);
        TileEntity tileentity = world.func_175625_s(pos);
        return Pair.of((Object)new Template.BlockInfo(pos, blockstate, compoundnbt), (Object)tileentity);
    }

    protected void addBlock(BlockPos pos, Pair<Template.BlockInfo, TileEntity> pair) {
        Template.BlockInfo blockInfo;
        Template.BlockInfo captured = (Template.BlockInfo)pair.getKey();
        BlockPos localPos = pos.func_177973_b((Vector3i)this.anchor);
        if (this.blocks.put(localPos, blockInfo = new Template.BlockInfo(localPos, captured.field_186243_b, captured.field_186244_c)) != null) {
            return;
        }
        this.bounds = this.bounds.func_111270_a(new AxisAlignedBB(localPos));
        TileEntity te = (TileEntity)pair.getValue();
        if (te != null && MountedStorage.canUseAsStorage(te)) {
            this.storage.put(localPos, new MountedStorage(te));
        }
        if (te != null && MountedFluidStorage.canUseAsStorage(te)) {
            this.fluidStorage.put(localPos, new MountedFluidStorage(te));
        }
        if (AllMovementBehaviours.contains(captured.field_186243_b.func_177230_c())) {
            this.actors.add((MutablePair<Template.BlockInfo, MovementContext>)MutablePair.of((Object)blockInfo, null));
        }
        if (AllInteractionBehaviours.contains(captured.field_186243_b.func_177230_c())) {
            this.interactors.put(localPos, AllInteractionBehaviours.of(captured.field_186243_b.func_177230_c()));
        }
        if (te instanceof CreativeCrateTileEntity && ((CreativeCrateTileEntity)te).getBehaviour(FilteringBehaviour.TYPE).getFilter().func_190926_b()) {
            this.hasUniversalCreativeCrate = true;
        }
    }

    @Nullable
    protected CompoundNBT getTileEntityNBT(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity == null) {
            return null;
        }
        CompoundNBT nbt = tileentity.func_189515_b(new CompoundNBT());
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        if (tileentity instanceof FluidTankTileEntity && nbt.func_74764_b("Controller")) {
            nbt.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.toLocalPos(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Controller")))));
        }
        return nbt;
    }

    protected void addGlue(SuperGlueEntity entity) {
        BlockPos pos = entity.getHangingPosition();
        Direction direction = entity.getFacingDirection();
        this.superglue.add((Pair<BlockPos, Direction>)Pair.of((Object)this.toLocalPos(pos), (Object)direction));
        this.glueToRemove.add(entity);
    }

    protected BlockPos toLocalPos(BlockPos globalPos) {
        return globalPos.func_177973_b((Vector3i)this.anchor);
    }

    protected boolean movementAllowed(BlockState state, World world, BlockPos pos) {
        return BlockMovementChecks.isMovementAllowed(state, world, pos);
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    public void readNBT(World world, CompoundNBT nbt, boolean spawnData) {
        this.blocks.clear();
        this.presentTileEntities.clear();
        this.specialRenderedTileEntities.clear();
        INBT blocks = nbt.func_74781_a("Blocks");
        boolean usePalettedDeserialization = blocks != null && blocks.func_74732_a() == 10 && ((CompoundNBT)blocks).func_74764_b("Palette");
        this.readBlocksCompound(blocks, world, usePalettedDeserialization);
        this.actors.clear();
        nbt.func_150295_c("Actors", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            Template.BlockInfo info = this.blocks.get(NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")));
            MovementContext context = MovementContext.readNBT(world, info, comp, this);
            this.getActors().add((MutablePair<Template.BlockInfo, MovementContext>)MutablePair.of((Object)info, (Object)context));
        });
        this.superglue.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Superglue", 10), c -> this.superglue.add((Pair<BlockPos, Direction>)Pair.of((Object)NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos")), (Object)Direction.func_82600_a((int)c.func_74771_c("Direction")))));
        this.seats.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Seats", 10), c -> this.seats.add(NBTUtil.func_186861_c((CompoundNBT)c)));
        this.seatMapping.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Passengers", 10), c -> this.seatMapping.put(NBTUtil.func_186860_b((INBT)NBTHelper.getINBT(c, "Id")), c.func_74762_e("Seat")));
        this.stabilizedSubContraptions.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("SubContraptions", 10), c -> this.stabilizedSubContraptions.put(c.func_186857_a("Id"), BlockFace.fromNBT(c.func_74775_l("Location"))));
        this.storage.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Storage", 10), c -> this.storage.put(NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos")), MountedStorage.deserialize(c.func_74775_l("Data"))));
        this.fluidStorage.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("FluidStorage", 10), c -> this.fluidStorage.put(NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos")), MountedFluidStorage.deserialize(c.func_74775_l("Data"))));
        this.interactors.clear();
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Interactors", 10), c -> {
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Pos"));
            MovingInteractionBehaviour behaviour = AllInteractionBehaviours.of(this.getBlocks().get((Object)pos).field_186243_b.func_177230_c());
            if (behaviour != null) {
                this.interactors.put(pos, behaviour);
            }
        });
        if (spawnData) {
            this.fluidStorage.forEach((pos, mfs) -> {
                TileEntity tileEntity = this.presentTileEntities.get(pos);
                if (!(tileEntity instanceof FluidTankTileEntity)) {
                    return;
                }
                FluidTankTileEntity tank = (FluidTankTileEntity)tileEntity;
                IFluidTank tankInventory = tank.getTankInventory();
                if (tankInventory instanceof FluidTank) {
                    ((FluidTank)tankInventory).setFluid(mfs.tank.getFluid());
                }
                tank.getFluidLevel().start(tank.getFillState());
                mfs.assignTileEntity(tank);
            });
        }
        IItemHandlerModifiable[] handlers = new IItemHandlerModifiable[this.storage.size()];
        int index = 0;
        for (MountedStorage mountedStorage : this.storage.values()) {
            handlers[index++] = mountedStorage.getItemHandler();
        }
        IFluidHandler[] fluidHandlers = new IFluidHandler[this.fluidStorage.size()];
        index = 0;
        for (MountedFluidStorage mountedStorage : this.fluidStorage.values()) {
            fluidHandlers[index++] = mountedStorage.getFluidHandler();
        }
        this.inventory = new ContraptionInvWrapper(handlers);
        this.fluidInventory = new CombinedTankWrapper(fluidHandlers);
        if (nbt.func_74764_b("BoundsFront")) {
            this.bounds = NBTHelper.readAABB(nbt.func_150295_c("BoundsFront", 5));
        }
        this.stalled = nbt.func_74767_n("Stalled");
        this.hasUniversalCreativeCrate = nbt.func_74767_n("BottomlessSupply");
        this.anchor = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Anchor"));
    }

    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Type", this.getType().id);
        CompoundNBT blocksNBT = this.writeBlocksCompound();
        ListNBT actorsNBT = new ListNBT();
        for (MutablePair<Template.BlockInfo, MovementContext> actor : this.getActors()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((Template.BlockInfo)actor.left).field_186242_a));
            AllMovementBehaviours.of(((Template.BlockInfo)actor.left).field_186243_b).writeExtraData((MovementContext)actor.right);
            ((MovementContext)actor.right).writeToNBT(compound);
            actorsNBT.add((Object)compound);
        }
        ListNBT superglueNBT = new ListNBT();
        ListNBT storageNBT = new ListNBT();
        if (!spawnPacket) {
            for (Pair pair : this.superglue) {
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)pair.getKey())));
                compoundNBT.func_74774_a("Direction", (byte)((Direction)pair.getValue()).func_176745_a());
                superglueNBT.add((Object)compoundNBT);
            }
            for (BlockPos blockPos : this.storage.keySet()) {
                CompoundNBT compoundNBT = new CompoundNBT();
                MountedStorage mountedStorage = this.storage.get(blockPos);
                if (!mountedStorage.isValid()) continue;
                compoundNBT.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)blockPos));
                compoundNBT.func_218657_a("Data", (INBT)mountedStorage.serialize());
                storageNBT.add((Object)compoundNBT);
            }
        }
        ListNBT fluidStorageNBT = new ListNBT();
        for (BlockPos blockPos : this.fluidStorage.keySet()) {
            CompoundNBT c = new CompoundNBT();
            MountedFluidStorage mountedStorage = this.fluidStorage.get(blockPos);
            if (!mountedStorage.isValid()) continue;
            c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)blockPos));
            c.func_218657_a("Data", (INBT)mountedStorage.serialize());
            fluidStorageNBT.add((Object)c);
        }
        ListNBT listNBT = new ListNBT();
        for (BlockPos pos : this.interactors.keySet()) {
            CompoundNBT c = new CompoundNBT();
            c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            listNBT.add((Object)c);
        }
        nbt.func_218657_a("Seats", (INBT)NBTHelper.writeCompoundList(this.getSeats(), NBTUtil::func_186859_a));
        nbt.func_218657_a("Passengers", (INBT)NBTHelper.writeCompoundList(this.getSeatMapping().entrySet(), e -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("Id", (INBT)NBTUtil.func_240626_a_((UUID)((UUID)e.getKey())));
            tag.func_74768_a("Seat", ((Integer)e.getValue()).intValue());
            return tag;
        }));
        nbt.func_218657_a("SubContraptions", (INBT)NBTHelper.writeCompoundList(this.stabilizedSubContraptions.entrySet(), e -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("Id", (UUID)e.getKey());
            tag.func_218657_a("Location", (INBT)((BlockFace)e.getValue()).serializeNBT());
            return tag;
        }));
        nbt.func_218657_a("Blocks", (INBT)blocksNBT);
        nbt.func_218657_a("Actors", (INBT)actorsNBT);
        nbt.func_218657_a("Interactors", (INBT)listNBT);
        nbt.func_218657_a("Superglue", (INBT)superglueNBT);
        nbt.func_218657_a("Storage", (INBT)storageNBT);
        nbt.func_218657_a("FluidStorage", (INBT)fluidStorageNBT);
        nbt.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)this.anchor));
        nbt.func_74757_a("Stalled", this.stalled);
        nbt.func_74757_a("BottomlessSupply", this.hasUniversalCreativeCrate);
        if (this.bounds != null) {
            ListNBT listNBT2 = NBTHelper.writeAABB(this.bounds);
            nbt.func_218657_a("BoundsFront", (INBT)listNBT2);
        }
        return nbt;
    }

    private CompoundNBT writeBlocksCompound() {
        CompoundNBT compound = new CompoundNBT();
        HashMapPalette palette = new HashMapPalette(GameData.getBlockStateIDMap(), 16, (i, s) -> {
            throw new IllegalStateException("Palette Map index exceeded maximum");
        }, NBTUtil::func_190008_d, NBTUtil::func_190009_a);
        ListNBT blockList = new ListNBT();
        for (Template.BlockInfo block : this.blocks.values()) {
            int id = palette.func_186041_a((Object)block.field_186243_b);
            CompoundNBT c = new CompoundNBT();
            c.func_74772_a("Pos", block.field_186242_a.func_218275_a());
            c.func_74768_a("State", id);
            if (block.field_186244_c != null) {
                c.func_218657_a("Data", (INBT)block.field_186244_c);
            }
            blockList.add((Object)c);
        }
        ListNBT paletteNBT = new ListNBT();
        palette.func_196969_b(paletteNBT);
        compound.func_218657_a("Palette", (INBT)paletteNBT);
        compound.func_218657_a("BlockList", (INBT)blockList);
        return compound;
    }

    private void readBlocksCompound(INBT compound, World world, boolean usePalettedDeserialization) {
        ListNBT blockList;
        HashMapPalette palette = null;
        if (usePalettedDeserialization) {
            CompoundNBT c = (CompoundNBT)compound;
            palette = new HashMapPalette(GameData.getBlockStateIDMap(), 16, (i, s) -> {
                throw new IllegalStateException("Palette Map index exceeded maximum");
            }, NBTUtil::func_190008_d, NBTUtil::func_190009_a);
            palette.func_196968_a(c.func_150295_c("Palette", 10));
            blockList = c.func_150295_c("BlockList", 10);
        } else {
            blockList = (ListNBT)compound;
        }
        HashMapPalette finalPalette = palette;
        blockList.forEach(e -> {
            CompoundNBT c = (CompoundNBT)e;
            Template.BlockInfo info = usePalettedDeserialization ? Contraption.readBlockInfo(c, (HashMapPalette<BlockState>)finalPalette) : Contraption.legacyReadBlockInfo(c);
            this.blocks.put(info.field_186242_a, info);
            if (world.field_72995_K) {
                Block block = info.field_186243_b.func_177230_c();
                CompoundNBT tag = info.field_186244_c;
                MovementBehaviour movementBehaviour = AllMovementBehaviours.of(block);
                if (tag == null) {
                    return;
                }
                tag.func_74768_a("x", info.field_186242_a.func_177958_n());
                tag.func_74768_a("y", info.field_186242_a.func_177956_o());
                tag.func_74768_a("z", info.field_186242_a.func_177952_p());
                TileEntity te = TileEntity.func_235657_b_((BlockState)info.field_186243_b, (CompoundNBT)tag);
                if (te == null) {
                    return;
                }
                te.func_226984_a_((World)new ContraptionTileWorld(world, te, info), te.func_174877_v());
                if (te instanceof KineticTileEntity) {
                    ((KineticTileEntity)te).setSpeed(0.0f);
                }
                te.func_195044_w();
                if (movementBehaviour == null || !movementBehaviour.hasSpecialInstancedRendering()) {
                    this.maybeInstancedTileEntities.add(te);
                }
                if (movementBehaviour != null && !movementBehaviour.renderAsNormalTileEntity()) {
                    return;
                }
                this.presentTileEntities.put(info.field_186242_a, te);
                this.specialRenderedTileEntities.add(te);
            }
        });
    }

    private static Template.BlockInfo readBlockInfo(CompoundNBT blockListEntry, HashMapPalette<BlockState> palette) {
        return new Template.BlockInfo(BlockPos.func_218283_e((long)blockListEntry.func_74763_f("Pos")), (BlockState)Objects.requireNonNull(palette.func_186039_a(blockListEntry.func_74762_e("State"))), blockListEntry.func_74764_b("Data") ? blockListEntry.func_74775_l("Data") : null);
    }

    private static Template.BlockInfo legacyReadBlockInfo(CompoundNBT blockListEntry) {
        return new Template.BlockInfo(NBTUtil.func_186861_c((CompoundNBT)blockListEntry.func_74775_l("Pos")), NBTUtil.func_190008_d((CompoundNBT)blockListEntry.func_74775_l("Block")), blockListEntry.func_74764_b("Data") ? blockListEntry.func_74775_l("Data") : null);
    }

    public void removeBlocksFromWorld(World world, BlockPos offset) {
        this.storage.values().forEach(MountedStorage::removeStorageFromWorld);
        this.fluidStorage.values().forEach(MountedFluidStorage::removeStorageFromWorld);
        this.glueToRemove.forEach(Entity::func_70106_y);
        for (boolean brittles : Iterate.trueAndFalse) {
            Iterator<Template.BlockInfo> iterator = this.blocks.values().iterator();
            while (iterator.hasNext()) {
                BlockPos add;
                Template.BlockInfo block = iterator.next();
                if (brittles != BlockMovementChecks.isBrittle(block.field_186243_b) || this.customBlockRemoval((IWorld)world, add = block.field_186242_a.func_177971_a((Vector3i)this.anchor).func_177971_a((Vector3i)offset), block.field_186243_b)) continue;
                BlockState oldState = world.func_180495_p(add);
                Block blockIn = oldState.func_177230_c();
                if (block.field_186243_b.func_177230_c() != blockIn) {
                    iterator.remove();
                }
                world.func_175713_t(add);
                int flags = 122;
                if (blockIn instanceof IWaterLoggable && oldState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)oldState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                    world.func_180501_a(add, Blocks.field_150355_j.func_176223_P(), flags);
                    continue;
                }
                world.func_180501_a(add, Blocks.field_150350_a.func_176223_P(), flags);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            Template.BlockInfo block = (Template.BlockInfo)object.next();
            BlockPos add = block.field_186242_a.func_177971_a((Vector3i)this.anchor).func_177971_a((Vector3i)offset);
            int flags = 67;
            world.func_184138_a(add, block.field_186243_b, Blocks.field_150350_a.func_176223_P(), flags);
            ServerWorld serverWorld = (ServerWorld)world;
            PointOfInterestType.func_221047_b((BlockState)block.field_186243_b).ifPresent(poiType -> world.func_73046_m().execute(() -> {
                serverWorld.func_217443_B().func_219135_a(add, poiType);
                DebugPacketSender.func_218799_a((ServerWorld)serverWorld, (BlockPos)add);
            }));
            world.markAndNotifyBlock(add, world.func_175726_f(add), block.field_186243_b, Blocks.field_150350_a.func_176223_P(), flags, 512);
            block.field_186243_b.func_196948_b((IWorld)world, add, flags & 0xFFFFFFFE);
        }
    }

    public void addBlocksToWorld(World world, StructureTransform transform) {
        int i;
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (Template.BlockInfo block : this.blocks.values()) {
                BlockState blockState;
                BlockState state;
                BlockPos targetPos;
                if (nonBrittles == BlockMovementChecks.isBrittle(block.field_186243_b) || this.customBlockPlacement((IWorld)world, targetPos = transform.apply(block.field_186242_a), state = transform.apply(block.field_186243_b))) continue;
                if (nonBrittles) {
                    for (Direction face : Iterate.directions) {
                        state = state.func_196956_a(face, world.func_180495_p(targetPos.func_177972_a(face)), (IWorld)world, targetPos, targetPos.func_177972_a(face));
                    }
                }
                if ((blockState = world.func_180495_p(targetPos)).func_185887_b((IBlockReader)world, targetPos) == -1.0f || state.func_196952_d((IBlockReader)world, targetPos).func_197766_b() && !blockState.func_196952_d((IBlockReader)world, targetPos).func_197766_b()) {
                    if (targetPos.func_177956_o() == 0) {
                        targetPos = targetPos.func_177984_a();
                    }
                    world.func_217379_c(2001, targetPos, Block.func_196246_j((BlockState)state));
                    Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)targetPos, null);
                    continue;
                }
                if (state.func_177230_c() instanceof IWaterLoggable && state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    FluidState FluidState2 = world.func_204610_c(targetPos);
                    state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(FluidState2.func_206886_c() == Fluids.field_204546_a));
                }
                world.func_175655_b(targetPos, true);
                world.func_180501_a(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.func_176722_c();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != Rotation.NONE;
                if (verticalRotation && (state.func_177230_c() instanceof PulleyBlock.RopeBlock || state.func_177230_c() instanceof PulleyBlock.MagnetBlock)) {
                    world.func_175655_b(targetPos, true);
                }
                TileEntity tileEntity = world.func_175625_s(targetPos);
                CompoundNBT tag = block.field_186244_c;
                if (tileEntity != null) {
                    tag = NBTProcessors.process(tileEntity, tag, false);
                }
                if (tileEntity != null && tag != null) {
                    Object mountedStorage;
                    tag.func_74768_a("x", targetPos.func_177958_n());
                    tag.func_74768_a("y", targetPos.func_177956_o());
                    tag.func_74768_a("z", targetPos.func_177952_p());
                    if (verticalRotation && tileEntity instanceof PulleyTileEntity) {
                        tag.func_82580_o("Offset");
                        tag.func_82580_o("InitialOffset");
                    }
                    if (tileEntity instanceof FluidTankTileEntity && tag.func_74764_b("LastKnownPos")) {
                        tag.func_218657_a("LastKnownPos", (INBT)NBTUtil.func_186859_a((BlockPos)BlockPos.field_177992_a.func_177977_b()));
                    }
                    tileEntity.func_230337_a_(block.field_186243_b, tag);
                    if (this.storage.containsKey(block.field_186242_a) && ((MountedStorage)(mountedStorage = this.storage.get(block.field_186242_a))).isValid()) {
                        ((MountedStorage)mountedStorage).addStorageToWorld(tileEntity);
                    }
                    if (this.fluidStorage.containsKey(block.field_186242_a) && ((MountedFluidStorage)(mountedStorage = this.fluidStorage.get(block.field_186242_a))).isValid()) {
                        ((MountedFluidStorage)mountedStorage).addStorageToWorld(tileEntity);
                    }
                }
                transform.apply(tileEntity);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            Template.BlockInfo block = (Template.BlockInfo)object.next();
            if (!this.shouldUpdateAfterMovement(block)) continue;
            BlockPos targetPos = transform.apply(block.field_186242_a);
            world.markAndNotifyBlock(targetPos, world.func_175726_f(targetPos), block.field_186243_b, block.field_186243_b, 67, 512);
        }
        for (i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.isSlotExternal(i)) continue;
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.fluidInventory.getTanks(); ++i) {
            this.fluidInventory.drain(this.fluidInventory.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
        }
        for (Pair<BlockPos, Direction> pair : this.superglue) {
            Direction targetFacing;
            BlockPos targetPos = transform.apply((BlockPos)pair.getKey());
            SuperGlueEntity entity = new SuperGlueEntity(world, targetPos, targetFacing = transform.transformFacing((Direction)pair.getValue()));
            if (!entity.onValidSurface() || world.field_72995_K) continue;
            world.func_217376_c((Entity)entity);
        }
    }

    public void addPassengersToWorld(World world, StructureTransform transform, List<Entity> seatedEntities) {
        for (Entity seatedEntity : seatedEntities) {
            if (this.getSeatMapping().isEmpty()) continue;
            Integer seatIndex = this.getSeatMapping().get(seatedEntity.func_110124_au());
            BlockPos seatPos = this.getSeats().get(seatIndex);
            if (!(world.func_180495_p(seatPos = transform.apply(seatPos)).func_177230_c() instanceof SeatBlock) || SeatBlock.isSeatOccupied(world, seatPos)) continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(World world) {
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (Template.BlockInfo)pair.left, this);
            AllMovementBehaviours.of(((Template.BlockInfo)pair.left).field_186243_b).startMoving(context);
            pair.setRight((Object)context);
        }
    }

    public void stop(World world) {
        this.foreachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = Vector3d.field_186680_a;
            ctx.relativeMotion = Vector3d.field_186680_a;
            ctx.rotation = v -> v;
        });
    }

    public void foreachActor(World world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.actors) {
            callBack.accept(AllMovementBehaviours.of(((Template.BlockInfo)pair.getLeft()).field_186243_b), (MovementContext)pair.getRight());
        }
    }

    protected boolean shouldUpdateAfterMovement(Template.BlockInfo info) {
        return !PointOfInterestType.func_221047_b((BlockState)info.field_186243_b).isPresent();
    }

    public void expandBoundsAroundAxis(Direction.Axis axis) {
        Set<BlockPos> blocks = this.getBlocks().keySet();
        int radius = (int)Math.ceil(Math.sqrt(Contraption.getRadius(blocks, axis)));
        GridAlignedBB betterBounds = GridAlignedBB.ofRadius((int)radius);
        GridAlignedBB contraptionBounds = GridAlignedBB.from((AxisAlignedBB)this.bounds);
        if (axis == Direction.Axis.X) {
            betterBounds.maxX = contraptionBounds.maxX;
            betterBounds.minX = contraptionBounds.minX;
        } else if (axis == Direction.Axis.Y) {
            betterBounds.maxY = contraptionBounds.maxY;
            betterBounds.minY = contraptionBounds.minY;
        } else if (axis == Direction.Axis.Z) {
            betterBounds.maxZ = contraptionBounds.maxZ;
            betterBounds.minZ = contraptionBounds.minZ;
        }
        this.bounds = betterBounds.toAABB();
    }

    public void addExtraInventories(Entity entity) {
    }

    public Map<UUID, Integer> getSeatMapping() {
        return this.seatMapping;
    }

    public BlockPos getSeatOf(UUID entityId) {
        if (!this.getSeatMapping().containsKey(entityId)) {
            return null;
        }
        int seatIndex = this.getSeatMapping().get(entityId);
        if (seatIndex >= this.getSeats().size()) {
            return null;
        }
        return this.getSeats().get(seatIndex);
    }

    public BlockPos getBearingPosOf(UUID subContraptionEntityId) {
        if (this.stabilizedSubContraptions.containsKey(subContraptionEntityId)) {
            return this.stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        }
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<BlockPos> getSeats() {
        return this.seats;
    }

    public Map<BlockPos, Template.BlockInfo> getBlocks() {
        return this.blocks;
    }

    public List<MutablePair<Template.BlockInfo, MovementContext>> getActors() {
        return this.actors;
    }

    public Map<BlockPos, MovingInteractionBehaviour> getInteractors() {
        return this.interactors;
    }

    public void updateContainedFluid(BlockPos localPos, FluidStack containedFluid) {
        MountedFluidStorage mountedFluidStorage = this.fluidStorage.get(localPos);
        if (mountedFluidStorage != null) {
            mountedFluidStorage.updateFluid(containedFluid);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new EmptyLighter(this);
    }

    public void invalidateColliders() {
        this.simplifiedEntityColliders = Optional.empty();
        this.gatherBBsOffThread();
    }

    private void gatherBBsOffThread() {
        this.getContraptionWorld();
        this.simplifiedEntityColliderProvider = CompletableFuture.supplyAsync(() -> {
            VoxelShape combinedShape = VoxelShapes.func_197880_a();
            for (Map.Entry<BlockPos, Template.BlockInfo> entry : this.blocks.entrySet()) {
                Template.BlockInfo info = entry.getValue();
                BlockPos localPos = entry.getKey();
                VoxelShape collisionShape = info.field_186243_b.func_196952_d((IBlockReader)this.world, localPos);
                if (collisionShape.func_197766_b()) continue;
                combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)collisionShape.func_197751_a((double)localPos.func_177958_n(), (double)localPos.func_177956_o(), (double)localPos.func_177952_p()), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            return combinedShape.func_197753_c().func_197756_d();
        }).thenAccept(r -> {
            this.simplifiedEntityColliders = Optional.of(r);
            this.simplifiedEntityColliderProvider = null;
        });
    }

    public static float getRadius(Set<BlockPos> blocks, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return Contraption.getMaxDistSqr(blocks, Vector3i::func_177956_o, Vector3i::func_177952_p);
            }
            case Y: {
                return Contraption.getMaxDistSqr(blocks, Vector3i::func_177958_n, Vector3i::func_177952_p);
            }
            case Z: {
                return Contraption.getMaxDistSqr(blocks, Vector3i::func_177958_n, Vector3i::func_177956_o);
            }
        }
        throw new IllegalStateException("Impossible axis");
    }

    public static float getMaxDistSqr(Set<BlockPos> blocks, ICoordinate one, ICoordinate other) {
        float maxDistSq = -1.0f;
        for (BlockPos pos : blocks) {
            float b;
            float a = one.get(pos);
            float distSq = a * a + (b = other.get(pos)) * b;
            if (!(distSq > maxDistSq)) continue;
            maxDistSq = distSq;
        }
        return maxDistSq;
    }

    public static class ContraptionInvWrapper
    extends CombinedInvWrapper {
        protected final boolean isExternal;

        public ContraptionInvWrapper(boolean isExternal, IItemHandlerModifiable ... itemHandler) {
            super(itemHandler);
            this.isExternal = isExternal;
        }

        public ContraptionInvWrapper(IItemHandlerModifiable ... itemHandler) {
            this(false, itemHandler);
        }

        public boolean isSlotExternal(int slot) {
            if (this.isExternal) {
                return true;
            }
            IItemHandlerModifiable handler = this.getHandlerFromIndex(this.getIndexForSlot(slot));
            return handler instanceof ContraptionInvWrapper && ((ContraptionInvWrapper)handler).isSlotExternal(slot);
        }
    }

    private static class ContraptionTileWorld
    extends WrappedWorld
    implements IFlywheelWorld {
        private final TileEntity te;
        private final Template.BlockInfo info;

        public ContraptionTileWorld(World world, TileEntity te, Template.BlockInfo info) {
            super(world);
            this.te = te;
            this.info = info;
        }

        @Override
        public BlockState func_180495_p(BlockPos pos) {
            if (!pos.equals((Object)this.te.func_174877_v())) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return this.info.field_186243_b;
        }

        public boolean func_195588_v(BlockPos pos) {
            return pos.equals((Object)this.te.func_174877_v());
        }
    }
}

