/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlockTypes;
import mekanism.generators.common.tile.fission.TileEntityControlRodAssembly;
import mekanism.generators.common.tile.fission.TileEntityFissionFuelAssembly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class FissionReactorValidator
extends CuboidStructureValidator<FissionReactorMultiblockData> {
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.m_60734_();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_REACTOR_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_REACTOR_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_REACTOR_LOGIC_ADAPTER})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    protected boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is((Block)state.m_60734_(), (BlockType[])new BlockType[]{GeneratorsBlockTypes.FISSION_FUEL_ASSEMBLY, GeneratorsBlockTypes.CONTROL_ROD_ASSEMBLY});
    }

    public FormationProtocol.FormationResult postcheck(FissionReactorMultiblockData structure, Long2ObjectMap<ChunkAccess> chunkMap) {
        HashMap<AssemblyPos, FuelAssembly> map = new HashMap<AssemblyPos, FuelAssembly>();
        HashSet<BlockPos> fuelAssemblyCoords = new HashSet<BlockPos>();
        int assemblyCount = 0;
        int surfaceArea = 0;
        for (BlockPos blockPos : structure.internalLocations) {
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, (BlockPos)blockPos);
            AssemblyPos pos = new AssemblyPos(blockPos.m_123341_(), blockPos.m_123343_());
            FuelAssembly assembly = (FuelAssembly)map.get(pos);
            if (tile instanceof TileEntityFissionFuelAssembly) {
                if (assembly == null) {
                    map.put(pos, new FuelAssembly(blockPos, false));
                } else {
                    assembly.fuelAssemblies.add(blockPos);
                }
                ++assemblyCount;
                surfaceArea += 6;
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!fuelAssemblyCoords.contains(blockPos.m_142300_(side))) continue;
                    surfaceArea -= 2;
                }
                fuelAssemblyCoords.add(blockPos);
                continue;
            }
            if (!(tile instanceof TileEntityControlRodAssembly)) continue;
            if (assembly == null) {
                map.put(pos, new FuelAssembly(blockPos, true));
                continue;
            }
            if (assembly.controlRodAssembly != null) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_EXTRA_CONTROL_ROD, (BlockPos)blockPos);
            }
            assembly.controlRodAssembly = blockPos;
        }
        if (map.isEmpty()) {
            return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_MISSING_FUEL_ASSEMBLY);
        }
        for (Map.Entry entry : map.entrySet()) {
            FuelAssembly assembly = (FuelAssembly)entry.getValue();
            FormationProtocol.FormationResult result = assembly.validate((AssemblyPos)entry.getKey());
            if (!result.isFormed()) {
                return result;
            }
            structure.assemblies.add(assembly.build());
        }
        structure.fuelAssemblies = assemblyCount;
        structure.surfaceArea = surfaceArea;
        return FormationProtocol.FormationResult.SUCCESS;
    }

    private record AssemblyPos(int x, int z) {
    }

    public static class FuelAssembly {
        public final SortedSet<BlockPos> fuelAssemblies = new TreeSet<BlockPos>(Comparator.comparingInt(Vec3i::m_123342_));
        public BlockPos controlRodAssembly;

        public FuelAssembly(BlockPos start, boolean isControlRod) {
            if (isControlRod) {
                this.controlRodAssembly = start;
            } else {
                this.fuelAssemblies.add(start);
            }
        }

        public FormationProtocol.FormationResult validate(AssemblyPos assemblyPos) {
            if (this.controlRodAssembly == null) {
                return FormationProtocol.FormationResult.fail((Component)GeneratorsLang.FISSION_INVALID_MISSING_CONTROL_ROD.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismLang.GENERIC_PARENTHESIS.translate(new Object[]{MekanismLang.GENERIC_WITH_COMMA.translate(new Object[]{assemblyPos.x, assemblyPos.z})})}));
            }
            if (this.fuelAssemblies.isEmpty()) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_BAD_FUEL_ASSEMBLY, (BlockPos)this.controlRodAssembly);
            }
            int prevY = -1;
            for (BlockPos coord : this.fuelAssemblies) {
                if (prevY != -1 && coord.m_123342_() != prevY + 1) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_MALFORMED_FUEL_ASSEMBLY, (BlockPos)coord);
                }
                prevY = coord.m_123342_();
            }
            if (this.controlRodAssembly.m_123342_() != prevY + 1) {
                return FormationProtocol.FormationResult.fail((ILangEntry)GeneratorsLang.FISSION_INVALID_BAD_CONTROL_ROD, (BlockPos)this.controlRodAssembly);
            }
            return FormationProtocol.FormationResult.SUCCESS;
        }

        public FormedAssembly build() {
            BlockPos base = this.fuelAssemblies.first();
            return new FormedAssembly(base, this.fuelAssemblies.size());
        }
    }

    public record FormedAssembly(BlockPos pos, int height) {
        public CompoundTag write() {
            CompoundTag ret = new CompoundTag();
            ret.m_128405_("x", this.pos.m_123341_());
            ret.m_128405_("y", this.pos.m_123342_());
            ret.m_128405_("z", this.pos.m_123343_());
            ret.m_128405_("height", this.height);
            return ret;
        }

        public static FormedAssembly read(CompoundTag nbt) {
            return new FormedAssembly(new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z")), nbt.m_128451_("height"));
        }
    }
}

