/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class KeyEventServerMessage
extends ComputerServerMessage {
    public static final int TYPE_DOWN = 0;
    public static final int TYPE_REPEAT = 1;
    public static final int TYPE_UP = 2;
    private final int type;
    private final int key;

    public KeyEventServerMessage(int instanceId, int type, int key) {
        super(instanceId);
        this.type = type;
        this.key = key;
    }

    public KeyEventServerMessage(@Nonnull FriendlyByteBuf buf) {
        super(buf);
        this.type = buf.readByte();
        this.key = buf.m_130242_();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.type);
        buf.m_130130_(this.key);
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        InputState input = container.getInput();
        if (this.type == 2) {
            input.keyUp(this.key);
        } else {
            input.keyDown(this.key, this.type == 1);
        }
    }
}

