/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TileCommandComputer
extends TileComputer {
    private final CommandReceiver receiver = new CommandReceiver();

    public TileCommandComputer(BlockEntityType<? extends TileComputer> type, BlockPos pos, BlockState state) {
        super(type, pos, state, ComputerFamily.COMMAND);
    }

    public CommandReceiver getReceiver() {
        return this.receiver;
    }

    public CommandSourceStack getSource() {
        String label;
        ServerComputer computer = this.getServerComputer();
        String name = "@";
        if (computer != null && (label = computer.getLabel()) != null) {
            name = label;
        }
        return new CommandSourceStack((CommandSource)this.receiver, Vec3.m_82512_((Vec3i)this.f_58858_), Vec2.f_82462_, (ServerLevel)this.m_58904_(), 2, name, (Component)new TextComponent(name), this.m_58904_().m_142572_(), null);
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ServerComputer computer = super.createComputer(instanceID, id);
        computer.addAPI(new CommandAPI(this));
        return computer;
    }

    @Override
    public boolean isUsable(Player player) {
        return TileCommandComputer.isCommandUsable(player) && super.isUsable(player);
    }

    public static boolean isCommandUsable(Player player) {
        MinecraftServer server = player.m_20194_();
        if (server == null || !server.m_6993_()) {
            player.m_5661_((Component)new TranslatableComponent("advMode.notEnabled"), true);
            return false;
        }
        if (ComputerCraft.commandRequireCreative ? !player.m_36337_() : !server.m_6846_().m_11303_(player.m_36316_())) {
            player.m_5661_((Component)new TranslatableComponent("advMode.notAllowed"), true);
            return false;
        }
        return true;
    }

    public class CommandReceiver
    implements CommandSource {
        private final Map<Integer, String> output = new HashMap<Integer, String>();

        public void clearOutput() {
            this.output.clear();
        }

        public Map<Integer, String> getOutput() {
            return this.output;
        }

        public Map<Integer, String> copyOutput() {
            return new HashMap<Integer, String>(this.output);
        }

        public void m_6352_(@Nonnull Component textComponent, @Nonnull UUID id) {
            this.output.put(this.output.size() + 1, textComponent.getString());
        }

        public boolean m_6999_() {
            return true;
        }

        public boolean m_7028_() {
            return true;
        }

        public boolean m_6102_() {
            return TileCommandComputer.this.m_58904_().m_46469_().m_46207_(GameRules.f_46138_);
        }
    }
}

